/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dan200.computercraft.client.model.LecternPocketModel;
import dan200.computercraft.client.model.LecternPrintoutModel;
import dan200.computercraft.client.pocket.ClientPocketComputers;
import dan200.computercraft.client.pocket.PocketComputerData;
import dan200.computercraft.client.render.RenderTypes;
import dan200.computercraft.client.render.text.FixedWidthFontRenderer;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.core.util.Colour;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.computer.terminal.NetworkedTerminal;
import dan200.computercraft.shared.lectern.CustomLecternBlockEntity;
import dan200.computercraft.shared.media.items.PrintoutData;
import dan200.computercraft.shared.media.items.PrintoutItem;
import dan200.computercraft.shared.pocket.items.PocketComputerItem;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector2f;

public class CustomLecternRenderer
implements BlockEntityRenderer<CustomLecternBlockEntity> {
    private static final int POCKET_TERMINAL_RENDER_DISTANCE = 32;
    private final BlockEntityRenderDispatcher berDispatcher;
    private final LecternPrintoutModel printoutModel;
    private final LecternPocketModel pocketModel;

    public CustomLecternRenderer(BlockEntityRendererProvider.Context context) {
        this.berDispatcher = context.getBlockEntityRenderDispatcher();
        this.printoutModel = new LecternPrintoutModel();
        this.pocketModel = new LecternPocketModel();
    }

    public static void applyLecternTransform(PoseStack poseStack, BlockState state) {
        poseStack.translate(0.5f, 1.0625f, 0.5f);
        poseStack.mulPose(Axis.YP.rotationDegrees(-((Direction)state.getValue((Property)LecternBlock.FACING)).getClockWise().toYRot()));
        poseStack.mulPose(Axis.ZP.rotationDegrees(67.5f));
        poseStack.translate(0.0f, -0.125f, 0.0f);
    }

    public void render(CustomLecternBlockEntity lectern, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        poseStack.pushPose();
        CustomLecternRenderer.applyLecternTransform(poseStack, lectern.getBlockState());
        ItemStack item = lectern.getItem();
        if (item.getItem() instanceof PrintoutItem) {
            VertexConsumer vertexConsumer = LecternPrintoutModel.MATERIAL.buffer(buffer, RenderType::entitySolid);
            if (item.is((Item)ModRegistry.Items.PRINTED_BOOK.get())) {
                this.printoutModel.renderBook(poseStack, vertexConsumer, packedLight, packedOverlay);
            } else {
                this.printoutModel.renderPages(poseStack, vertexConsumer, packedLight, packedOverlay, PrintoutData.getOrEmpty((DataComponentHolder)item).pages());
            }
        } else {
            Item vertexConsumer = item.getItem();
            if (vertexConsumer instanceof PocketComputerItem) {
                PocketComputerItem pocket = (PocketComputerItem)vertexConsumer;
                PocketComputerData computer = ClientPocketComputers.get(item);
                this.pocketModel.render(poseStack, buffer, packedLight, packedOverlay, pocket.getFamily(), DyedItemColor.getOrDefault((ItemStack)item, (int)-1), FastColor.ARGB32.opaque((int)(computer == null || computer.getLightState() == -1 ? Colour.BLACK.getHex() : computer.getLightState())));
                CustomLecternRenderer.applyPocketComputerTerminalTransform(poseStack);
                NetworkedTerminal terminal = computer == null ? null : computer.getTerminal();
                FixedWidthFontRenderer.QuadEmitter quadEmitter = FixedWidthFontRenderer.toVertexConsumer(poseStack, buffer.getBuffer(RenderTypes.TERMINAL));
                if (terminal != null && Vec3.atCenterOf((Vec3i)lectern.getBlockPos()).closerThan((Position)this.berDispatcher.camera.getPosition(), 32.0)) {
                    CustomLecternRenderer.renderPocketTerminal(poseStack, quadEmitter, terminal);
                } else {
                    FixedWidthFontRenderer.drawEmptyTerminal(quadEmitter, 0.0f, 0.0f, 0.375f, 0.4375f);
                }
            }
        }
        poseStack.popPose();
    }

    public static void applyPocketComputerTerminalTransform(PoseStack poseStack) {
        poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        poseStack.translate(-0.1875, 0.25, 0.0625);
        poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
    }

    public static Vector2f applyScaledPocketComputerTerminalTransform(PoseStack poseStack, Terminal terminal) {
        int width = terminal.getWidth() * 6;
        int height = terminal.getHeight() * 9;
        float scaleX = 0.375f / (float)(width + 4);
        float scaleY = 0.4375f / (float)(height + 4);
        float scale = Math.min(scaleX, scaleY);
        poseStack.scale(scale, scale, -1.0f);
        float marginX = (0.375f / scale - (float)width) / 2.0f;
        float marginY = (0.4375f / scale - (float)height) / 2.0f;
        poseStack.translate(marginX, marginY, 0.0f);
        return new Vector2f(marginX, marginY);
    }

    private static void renderPocketTerminal(PoseStack poseStack, FixedWidthFontRenderer.QuadEmitter quadEmitter, Terminal terminal) {
        Vector2f margin = CustomLecternRenderer.applyScaledPocketComputerTerminalTransform(poseStack, terminal);
        FixedWidthFontRenderer.drawTerminal(quadEmitter, 0.0f, 0.0f, terminal, margin.y(), margin.y(), margin.x(), margin.x());
    }
}

