/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;

public class LecternPrintoutModel {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)"entity/printout");
    public static final Material MATERIAL = new Material(InventoryMenu.BLOCK_ATLAS, TEXTURE);
    private static final int TEXTURE_WIDTH = 32;
    private static final int TEXTURE_HEIGHT = 32;
    private static final String PAGE_1 = "page_1";
    private static final String PAGE_2 = "page_2";
    private static final String PAGE_3 = "page_3";
    private static final List<String> PAGES = List.of("page_1", "page_2", "page_3");
    private final ModelPart pagesRoot = LecternPrintoutModel.buildPages();
    private final ModelPart bookRoot = LecternPrintoutModel.buildBook();
    private final ModelPart[] pages = (ModelPart[])PAGES.stream().map(arg_0 -> ((ModelPart)this.pagesRoot).getChild(arg_0)).toArray(ModelPart[]::new);

    private static ModelPart buildPages() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition parts = mesh.getRoot();
        parts.addOrReplaceChild(PAGE_1, CubeListBuilder.create().texOffs(0, 0).addBox(-0.005f, -4.0f, -2.5f, 1.0f, 8.0f, 5.0f), PartPose.ZERO);
        parts.addOrReplaceChild(PAGE_2, CubeListBuilder.create().texOffs(12, 0).addBox(-0.005f, -4.0f, -2.5f, 1.0f, 8.0f, 5.0f), PartPose.offsetAndRotation((float)-0.125f, (float)0.0f, (float)1.5f, (float)0.19634955f, (float)0.0f, (float)0.0f));
        parts.addOrReplaceChild(PAGE_3, CubeListBuilder.create().texOffs(12, 0).addBox(-0.005f, -4.0f, -2.5f, 1.0f, 8.0f, 5.0f), PartPose.offsetAndRotation((float)-0.25f, (float)0.0f, (float)-1.5f, (float)-0.3926991f, (float)0.0f, (float)0.0f));
        return mesh.getRoot().bake(32, 32);
    }

    private static ModelPart buildBook() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition parts = mesh.getRoot();
        parts.addOrReplaceChild("spine", CubeListBuilder.create().texOffs(12, 15).addBox(-0.005f, -5.0f, -0.5f, 0.0f, 10.0f, 1.0f), PartPose.ZERO);
        float angle = (float)Math.toRadians(5.0);
        parts.addOrReplaceChild("left", CubeListBuilder.create().texOffs(0, 10).addBox(0.0f, -5.0f, -6.0f, 0.0f, 10.0f, 6.0f).texOffs(0, 0).addBox(0.005f, -4.0f, -5.0f, 1.0f, 8.0f, 5.0f), PartPose.offsetAndRotation((float)-0.005f, (float)0.0f, (float)-0.5f, (float)0.0f, (float)(-angle), (float)0.0f));
        parts.addOrReplaceChild("right", CubeListBuilder.create().texOffs(14, 10).addBox(0.0f, -5.0f, 0.0f, 0.0f, 10.0f, 6.0f).texOffs(0, 0).addBox(0.005f, -4.0f, 0.0f, 1.0f, 8.0f, 5.0f), PartPose.offsetAndRotation((float)-0.005f, (float)0.0f, (float)0.5f, (float)0.0f, (float)angle, (float)0.0f));
        return mesh.getRoot().bake(32, 32);
    }

    public void renderBook(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay) {
        this.bookRoot.render(poseStack, buffer, packedLight, packedOverlay);
    }

    public void renderPages(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int pageCount) {
        int i;
        if (pageCount > this.pages.length) {
            pageCount = this.pages.length;
        }
        for (i = 0; i < pageCount; ++i) {
            this.pages[i].visible = true;
        }
        while (i < this.pages.length) {
            this.pages[i].visible = false;
            ++i;
        }
        this.pagesRoot.render(poseStack, buffer, packedLight, packedOverlay);
    }
}

