/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FastColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.Vec3;
import vectorwing.farmersdelight.common.block.state.CanvasSign;
import vectorwing.farmersdelight.common.registry.ModAtlases;

public class CanvasSignRenderer
extends SignRenderer {
    public static final Vec3 TEXT_OFFSET = new Vec3(0.0, 0.3333333432674408, 0.046666666865348816);
    private static final int OUTLINE_RENDER_DISTANCE = Mth.square((int)16);
    private final SignRenderer.SignModel signModel;
    private final Font font;

    public CanvasSignRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
        this.signModel = new SignRenderer.SignModel(context.bakeLayer(ModelLayers.createSignModelName((WoodType)WoodType.SPRUCE)));
        this.font = context.getFont();
    }

    public void render(SignBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        BlockState state = blockEntity.getBlockState();
        SignBlock block = (SignBlock)state.getBlock();
        SignRenderer.SignModel model = this.signModel;
        model.stick.visible = block instanceof StandingSignBlock;
        DyeColor dye = null;
        if (block instanceof CanvasSign) {
            CanvasSign canvasSign = (CanvasSign)block;
            dye = canvasSign.getBackgroundColor();
        }
        this.renderSignWithText(blockEntity, poseStack, bufferSource, packedLight, packedOverlay, state, block, dye, (Model)model);
    }

    protected void renderSignWithText(SignBlockEntity signBlockEntity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, BlockState state, SignBlock block, @Nullable DyeColor dye, Model model) {
        poseStack.pushPose();
        this.translateSign(poseStack, -block.getYRotationDegrees(state), state);
        this.renderSign(poseStack, bufferSource, packedLight, packedOverlay, dye, model);
        this.renderSignText(signBlockEntity.getBlockPos(), signBlockEntity.getFrontText(), poseStack, bufferSource, packedLight, signBlockEntity.getTextLineHeight(), signBlockEntity.getMaxTextLineWidth(), true);
        this.renderSignText(signBlockEntity.getBlockPos(), signBlockEntity.getBackText(), poseStack, bufferSource, packedLight, signBlockEntity.getTextLineHeight(), signBlockEntity.getMaxTextLineWidth(), false);
        poseStack.popPose();
    }

    protected void translateSign(PoseStack poseStack, float angle, BlockState state) {
        poseStack.translate(0.5f, 0.75f * this.getSignModelRenderScale(), 0.5f);
        poseStack.mulPose(Axis.YP.rotationDegrees(angle));
        if (!(state.getBlock() instanceof StandingSignBlock)) {
            poseStack.translate(0.0f, -0.3125f, -0.4375f);
        }
    }

    protected void renderSign(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, @Nullable DyeColor dye, Model model) {
        poseStack.pushPose();
        float rootScale = this.getSignModelRenderScale();
        poseStack.scale(rootScale, -rootScale, -rootScale);
        Material material = this.getCanvasSignMaterial(dye);
        VertexConsumer vertexConsumer = material.buffer(bufferSource, arg_0 -> ((Model)model).renderType(arg_0));
        this.renderSignModel(poseStack, packedLight, packedOverlay, model, vertexConsumer);
        poseStack.popPose();
    }

    protected void renderSignModel(PoseStack poseStack, int packedLight, int packedOverlay, Model model, VertexConsumer vertexConsumer) {
        SignRenderer.SignModel signModel = (SignRenderer.SignModel)model;
        signModel.root.render(poseStack, vertexConsumer, packedLight, packedOverlay);
    }

    protected void renderSignText(BlockPos pos, SignText text, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int textLineHeight, int maxTextLineWidth, boolean isFrontText) {
        int light;
        boolean hasOutline;
        int baseColor;
        int darkColor;
        poseStack.pushPose();
        this.translateSignText(poseStack, isFrontText, this.getTextOffset());
        FormattedCharSequence[] formattedCharSequenceList = text.getRenderMessages(Minecraft.getInstance().isTextFilteringEnabled(), component -> {
            List list = this.font.split((FormattedText)component, maxTextLineWidth);
            return list.isEmpty() ? FormattedCharSequence.EMPTY : (FormattedCharSequence)list.get(0);
        });
        if (text.hasGlowingText()) {
            darkColor = CanvasSignRenderer.getDarkColor(text, true);
            baseColor = text.getColor().getTextColor();
            hasOutline = CanvasSignRenderer.isOutlineVisible(pos, baseColor);
            light = 0xF000F0;
        } else {
            baseColor = darkColor = CanvasSignRenderer.getDarkColor(text, false);
            hasOutline = false;
            light = packedLight;
        }
        int verticalOffset = 2 * textLineHeight + this.getCustomVerticalOffset();
        for (int i = 0; i < 4; ++i) {
            FormattedCharSequence formattedCharSequence = formattedCharSequenceList[i];
            float x = -this.font.width(formattedCharSequence) / 2;
            float y = i * textLineHeight - verticalOffset;
            if (hasOutline) {
                this.font.drawInBatch8xOutline(formattedCharSequence, x, y, baseColor, darkColor, poseStack.last().pose(), bufferSource, light);
                continue;
            }
            this.font.drawInBatch(formattedCharSequence, x, y, baseColor, false, poseStack.last().pose(), bufferSource, Font.DisplayMode.POLYGON_OFFSET, 0, light);
        }
        poseStack.popPose();
    }

    private void translateSignText(PoseStack poseStack, boolean isFrontText, Vec3 pos) {
        if (!isFrontText) {
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        }
        float textScale = 0.015625f * this.getSignTextRenderScale();
        poseStack.translate(pos.x, pos.y, pos.z);
        poseStack.scale(textScale, -textScale, textScale);
    }

    public static boolean isOutlineVisible(BlockPos pos, int textColor) {
        if (textColor == DyeColor.BLACK.getTextColor()) {
            return true;
        }
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer localPlayer = minecraft.player;
        if (localPlayer != null && minecraft.options.getCameraType().isFirstPerson() && localPlayer.isScoping()) {
            return true;
        }
        Entity entity = minecraft.getCameraEntity();
        return entity != null && entity.distanceToSqr(Vec3.atCenterOf((Vec3i)pos)) < (double)OUTLINE_RENDER_DISTANCE;
    }

    protected static int getDarkColor(SignText text, boolean isOutlineVisible) {
        int textColor = text.getColor().getTextColor();
        if (textColor == DyeColor.BLACK.getTextColor() && text.hasGlowingText()) {
            return -988212;
        }
        double brightness = isOutlineVisible ? 0.4 : 0.6;
        int red = (int)((double)FastColor.ARGB32.red((int)textColor) * brightness);
        int green = (int)((double)FastColor.ARGB32.green((int)textColor) * brightness);
        int blue = (int)((double)FastColor.ARGB32.blue((int)textColor) * brightness);
        return FastColor.ARGB32.color((int)0, (int)red, (int)green, (int)blue);
    }

    Vec3 getTextOffset() {
        return TEXT_OFFSET;
    }

    public int getCustomVerticalOffset() {
        return -1;
    }

    public Material getCanvasSignMaterial(@Nullable DyeColor dyeColor) {
        return ModAtlases.getCanvasSignMaterial(dyeColor);
    }
}

