/*
 * Decompiled with CFR 0.152.
 */
package com.github.talrey.createdeco.blocks;

import com.github.talrey.createdeco.BlockRegistry;
import com.github.talrey.createdeco.blocks.CatwalkBlock;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CatwalkStairBlock
extends Block
implements IWrenchable,
ProperWaterloggedBlock {
    public static final BooleanProperty RAILING_LEFT = BooleanProperty.create((String)"railing_left");
    public static final BooleanProperty RAILING_RIGHT = BooleanProperty.create((String)"railing_right");
    public final String metal;
    private static final VoxelShape BOX_NORTH = Shapes.join((VoxelShape)Block.box((double)0.0, (double)14.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape BOX_SOUTH = Shapes.join((VoxelShape)Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), (VoxelShape)Block.box((double)0.0, (double)6.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape BOX_WEST = Shapes.join((VoxelShape)Block.box((double)8.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)6.0, (double)0.0, (double)8.0, (double)8.0, (double)16.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape BOX_EAST = Shapes.join((VoxelShape)Block.box((double)0.0, (double)14.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0), (VoxelShape)Block.box((double)8.0, (double)6.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), (BooleanOp)BooleanOp.OR);

    public CatwalkStairBlock(BlockBehaviour.Properties props, String metal) {
        super(props);
        this.metal = metal;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)RAILING_LEFT, (Comparable)Boolean.valueOf(false))).setValue((Property)RAILING_RIGHT, (Comparable)Boolean.valueOf(false)));
    }

    public static boolean isCatwalkStair(ItemStack test) {
        BlockItem be;
        Item item = test.getItem();
        return item instanceof BlockItem && (be = (BlockItem)item).getBlock() instanceof CatwalkStairBlock;
    }

    public static boolean isCatwalkStair(Block test) {
        return test instanceof CatwalkBlock || test instanceof CatwalkStairBlock;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction facing = ctx.getHorizontalDirection();
        FluidState fluid = ctx.getLevel().getFluidState(ctx.getClickedPos());
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facing.getOpposite())).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(fluid.getType() == Fluids.WATER));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
        builder.add(new Property[]{BlockStateProperties.WATERLOGGED});
        builder.add(new Property[]{RAILING_LEFT});
        builder.add(new Property[]{RAILING_RIGHT});
    }

    public boolean canPlaceLiquid(@Nullable Player playerEntity, BlockGetter world, BlockPos pos, BlockState state, Fluid fluid) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) == false && fluid == Fluids.WATER;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : Fluids.EMPTY.defaultFluidState();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return switch ((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            case Direction.SOUTH -> BOX_SOUTH;
            case Direction.EAST -> BOX_EAST;
            case Direction.WEST -> BOX_WEST;
            default -> BOX_NORTH;
        };
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        BlockPos pos = context.getClickedPos();
        Vec3 subbox = context.getClickLocation().subtract(pos.getCenter());
        Level level = context.getLevel();
        Player player = context.getPlayer();
        if (((Boolean)state.getValue((Property)RAILING_RIGHT)).booleanValue() || ((Boolean)state.getValue((Property)RAILING_LEFT)).booleanValue()) {
            double xPos = subbox.x;
            double zPos = subbox.z;
            Direction dir = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            boolean left = false;
            if (dir == Direction.NORTH) {
                boolean bl = left = xPos > 0.0;
            }
            if (dir == Direction.SOUTH) {
                boolean bl = left = xPos < 0.0;
            }
            if (dir == Direction.EAST) {
                boolean bl = left = zPos > 0.0;
            }
            if (dir == Direction.WEST) {
                boolean bl = left = zPos < 0.0;
            }
            if (level.isClientSide() || !((Boolean)state.getValue((Property)(left ? RAILING_LEFT : RAILING_RIGHT))).booleanValue()) {
                return InteractionResult.PASS;
            }
            level.setBlock(pos, (BlockState)state.setValue((Property)(left ? RAILING_LEFT : RAILING_RIGHT), (Comparable)Boolean.valueOf(false)), 3);
            if (!player.getAbilities().instabuild) {
                player.addItem(new ItemStack((ItemLike)BlockRegistry.CATWALK_RAILINGS.get(this.metal)));
            }
            IWrenchable.playRemoveSound((Level)level, (BlockPos)pos);
            return InteractionResult.SUCCESS;
        }
        level.removeBlock(pos, false);
        if (!player.getAbilities().instabuild) {
            player.addItem(new ItemStack((ItemLike)state.getBlock().asItem()));
        }
        IWrenchable.playRemoveSound((Level)level, (BlockPos)pos);
        return InteractionResult.SUCCESS;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
    }
}

