/*
 * Decompiled with CFR 0.152.
 */
package com.github.talrey.createdeco.api;

import com.github.talrey.createdeco.ItemRegistry;
import java.util.HashMap;
import java.util.Locale;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class CreateDecoTags {
    private static final HashMap<String, TagKey<Item>> PLATES = new HashMap();
    private static final HashMap<String, TagKey<Item>> NUGGETS = new HashMap();
    private static final HashMap<String, TagKey<Item>> INGOTS = new HashMap();
    private static final HashMap<String, TagKey<Item>> BLOCK_ITEM = new HashMap();
    private static final HashMap<String, TagKey<Block>> BLOCKS = new HashMap();
    public static final TagKey<Item> PLACARDS = CreateDecoTags.of("createdeco", "placards");
    public static final TagKey<Item> GLASS = CreateDecoTags.common("glass_blocks/colorless");

    public static void init() {
        for (String metal : ItemRegistry.METAL_TYPES.keySet()) {
            Object metalID = metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_");
            if (((String)metalID).equals("andesite")) {
                metalID = (String)metalID + "_alloy";
            }
            PLATES.put(metal, CreateDecoTags.common("plates/" + (String)metalID));
            NUGGETS.put(metal, CreateDecoTags.common("nuggets/" + (String)metalID));
            INGOTS.put(metal, CreateDecoTags.common("ingots/" + (String)metalID));
            BLOCK_ITEM.put(metal, CreateDecoTags.common("storage_blocks/" + (String)metalID));
            BLOCKS.put(metal, (TagKey<Block>)BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)("storage_blocks/" + (String)metalID))));
        }
        PLATES.put("Gold", CreateDecoTags.common("plates/gold"));
        NUGGETS.put("Gold", CreateDecoTags.common("nuggets/gold"));
        INGOTS.put("Gold", CreateDecoTags.common("ingots/gold"));
        BLOCK_ITEM.put("Gold", CreateDecoTags.common("storage_blocks/gold"));
        BLOCKS.put("Gold", (TagKey<Block>)BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"storage_blocks/gold")));
        PLATES.put("Netherite", CreateDecoTags.common("plates/netherite"));
        NUGGETS.put("Netherite", CreateDecoTags.common("nuggets/netherite"));
        INGOTS.put("Netherite", CreateDecoTags.common("ingots/netherite"));
        BLOCK_ITEM.put("Netherite", CreateDecoTags.common("storage_blocks/netherite"));
        BLOCKS.put("Netherite", (TagKey<Block>)BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"storage_blocks/netherite")));
    }

    public static TagKey<Item> plate(String metal) {
        return PLATES.get(metal);
    }

    public static TagKey<Item> nugget(String metal) {
        return NUGGETS.get(metal);
    }

    public static TagKey<Item> ingot(String metal) {
        return INGOTS.get(metal);
    }

    public static TagKey<Item> blockItem(String metal) {
        return BLOCK_ITEM.get(metal);
    }

    public static TagKey<Block> block(String metal) {
        return BLOCKS.get(metal);
    }

    private static TagKey<Item> of(String namespace, String path) {
        return ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path));
    }

    private static TagKey<Item> common(String path) {
        return CreateDecoTags.of("c", path);
    }
}

