/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common.content.kinetics.verticalBelt;

import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.VersionedInventoryTrackerBehaviour;
import dev.khloeleclair.create.additionallogistics.common.content.kinetics.verticalBelt.AbstractVerticalBeltBlock;
import dev.khloeleclair.create.additionallogistics.common.content.kinetics.verticalBelt.ItemHandlerVerticalBeltSegment;
import dev.khloeleclair.create.additionallogistics.common.content.kinetics.verticalBelt.VerticalBeltBlock;
import dev.khloeleclair.create.additionallogistics.common.content.kinetics.verticalBelt.VerticalBeltInventory;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class VerticalBeltBlockEntity
extends KineticBlockEntity {
    public int beltHeight;
    public int index;
    public Direction lastInsert;
    public boolean covered;
    @Nullable
    protected BlockPos controller = BlockPos.ZERO;
    @Nullable
    protected VerticalBeltInventory inventory;
    @Nullable
    protected IItemHandler itemHandler = null;
    public VersionedInventoryTrackerBehaviour invVersionTracker;
    @Nullable
    public CompoundTag trackerUpdateTag;

    public VerticalBeltBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.invVersionTracker = new VersionedInventoryTrackerBehaviour((SmartBlockEntity)this);
        behaviours.add((BlockEntityBehaviour)this.invVersionTracker);
    }

    public boolean isController() {
        return this.controller != null && this.controller.equals((Object)this.worldPosition);
    }

    public void setController(BlockPos pos) {
        this.controller = pos;
    }

    public BlockPos getController() {
        return this.controller == null ? this.worldPosition : this.controller;
    }

    @Nullable
    public VerticalBeltBlockEntity getControllerBE() {
        BlockEntity blockEntity;
        if (this.controller != null && this.level != null && this.level.isLoaded(this.controller) && (blockEntity = this.level.getBlockEntity(this.controller)) instanceof VerticalBeltBlockEntity) {
            VerticalBeltBlockEntity be = (VerticalBeltBlockEntity)blockEntity;
            return be;
        }
        return null;
    }

    public float getBeltMovementSpeed() {
        return this.getSpeed() / 480.0f;
    }

    public void tick() {
        if (this.beltHeight == 0) {
            AbstractVerticalBeltBlock.initBelt(this.level, this.worldPosition);
        }
        super.tick();
        if (!(this.level.getBlockState(this.worldPosition).getBlock() instanceof VerticalBeltBlock)) {
            return;
        }
        this.initializeItemHandler();
        if (!this.isController()) {
            return;
        }
        this.invalidateRenderBoundingBox();
        this.getInventory().tick();
    }

    public float calculateStressApplied() {
        if (!this.isController()) {
            return 0.0f;
        }
        return super.calculateStressApplied();
    }

    protected AABB createRenderBoundingBox() {
        AABB result = super.createRenderBoundingBox();
        if (this.isController()) {
            result = result.setMaxY(result.getMaxPosition().y + (double)this.beltHeight + 1.0);
        }
        return result;
    }

    protected void initializeItemHandler() {
        BlockEntity blockEntity;
        if (this.level.isClientSide || this.itemHandler != null) {
            return;
        }
        if (this.beltHeight == 0 || this.controller == null) {
            return;
        }
        if (!this.level.isLoaded(this.controller) || !((blockEntity = this.level.getBlockEntity(this.controller)) instanceof VerticalBeltBlockEntity)) {
            return;
        }
        VerticalBeltBlockEntity vbbe = (VerticalBeltBlockEntity)blockEntity;
        VerticalBeltInventory inventory = vbbe.getInventory();
        if (inventory == null) {
            return;
        }
        this.itemHandler = new ItemHandlerVerticalBeltSegment(inventory, this.index);
        this.invalidateCapabilities();
    }

    public VerticalBeltInventory getInventory() {
        if (!this.isController()) {
            VerticalBeltBlockEntity controllerBE = this.getControllerBE();
            if (controllerBE != null) {
                return controllerBE.getInventory();
            }
            return null;
        }
        if (this.inventory == null) {
            this.inventory = new VerticalBeltInventory(this);
        }
        return this.inventory;
    }

    public void invalidateItemHandler() {
        this.invalidateCapabilities();
        this.itemHandler = null;
    }
}

