/*
 * Decompiled with CFR 0.152.
 */
package dev.khloeleclair.create.additionallogistics.common.content.kinetics.verticalBelt;

import com.simibubi.create.content.decoration.encasing.EncasableBlock;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import dev.khloeleclair.create.additionallogistics.common.content.kinetics.verticalBelt.VerticalBeltBlockEntity;
import dev.khloeleclair.create.additionallogistics.common.content.kinetics.verticalBelt.VerticalBeltHelper;
import dev.khloeleclair.create.additionallogistics.common.utilities.FlexiblePoleHelper;
import java.util.function.Predicate;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.DebugLevelSource;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class AbstractVerticalBeltBlock
extends HorizontalKineticBlock {
    public static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());

    public AbstractVerticalBeltBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.block();
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.getValue(HORIZONTAL_FACING)).getAxis();
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public static void initBelt(Level world, BlockPos pos) {
        BlockPos nextPos;
        BlockState nextState;
        ServerLevel sl;
        if (world.isClientSide || world instanceof ServerLevel && (sl = (ServerLevel)world).getChunkSource().getGenerator() instanceof DebugLevelSource) {
            return;
        }
        BlockState state = world.getBlockState(pos);
        if (!(state.getBlock() instanceof AbstractVerticalBeltBlock)) {
            return;
        }
        int limit = 1000;
        BlockPos currentPos = pos;
        while (limit-- > 0 && (nextState = world.getBlockState(nextPos = currentPos.below())).getBlock() instanceof AbstractVerticalBeltBlock) {
            currentPos = nextPos;
        }
        int index = 0;
        VerticalBeltHelper.Positions positions = new VerticalBeltHelper.Positions((LevelReader)world, currentPos);
        for (BlockPos beltPos : positions) {
            BlockEntity blockEntity = world.getBlockEntity(beltPos);
            if (!(blockEntity instanceof VerticalBeltBlockEntity)) {
                world.destroyBlock(currentPos, true);
                return;
            }
            VerticalBeltBlockEntity vbbe = (VerticalBeltBlockEntity)blockEntity;
            vbbe.setController(currentPos);
            vbbe.beltHeight = positions.size();
            vbbe.index = index++;
            vbbe.attachKinetics();
            vbbe.setChanged();
            vbbe.sendData();
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        EncasableBlock encasable;
        ItemInteractionResult result;
        if (player.isShiftKeyDown() || !player.mayBuild()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        AbstractVerticalBeltBlock abstractVerticalBeltBlock = this;
        if (abstractVerticalBeltBlock instanceof EncasableBlock && (result = (encasable = (EncasableBlock)abstractVerticalBeltBlock).tryEncase(state, level, pos, stack, player, hand, hitResult)).consumesAction()) {
            return result;
        }
        IPlacementHelper helper = PlacementHelpers.get((int)placementHelperId);
        if (helper != null && helper.matchesItem(stack)) {
            return helper.getOffset(player, level, state, pos, hitResult).placeInWorld(level, (BlockItem)stack.getItem(), player, hand, hitResult);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public static class PlacementHelper
    extends FlexiblePoleHelper<Direction> {
        public PlacementHelper() {
            super(state -> state.getBlock() instanceof AbstractVerticalBeltBlock, state -> (Direction)state.getValue(HorizontalKineticBlock.HORIZONTAL_FACING), HorizontalKineticBlock.HORIZONTAL_FACING);
        }

        public Predicate<ItemStack> getItemPredicate() {
            return i -> {
                BlockItem bi;
                Item patt0$temp = i.getItem();
                return patt0$temp instanceof BlockItem && (bi = (BlockItem)patt0$temp).getBlock() instanceof AbstractVerticalBeltBlock;
            };
        }
    }
}

