/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.watut.particle;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public abstract class ParticleRotating
extends TextureSheetParticle {
    public boolean useCustomRotation = true;
    public float prevRotationYaw;
    public float rotationYaw;
    public float prevRotationPitch;
    public float rotationPitch;
    public float prevRotationRoll;
    public float rotationRoll;
    public float brightness = 1.0f;
    public int despawnCountdown = 40;
    public static ParticleRenderType CUSTOM = new ParticleRenderType(){

        @Nullable
        public BufferBuilder begin(Tesselator tesselator, TextureManager textureManager) {
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableBlend();
            return tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
        }

        public void begin(BufferBuilder p_107469_, TextureManager p_107470_) {
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableBlend();
        }

        public String toString() {
            return "CUSTOM";
        }
    };
    public static ParticleRenderType PARTICLE_SHEET_TRANSLUCENT_NO_FACE_CULL = new ParticleRenderType(){

        @Nullable
        public BufferBuilder begin(Tesselator tesselator, TextureManager textureManager) {
            RenderSystem.depthMask((boolean)true);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_PARTICLES);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableCull();
            return tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
        }

        public String toString() {
            return "PARTICLE_SHEET_TRANSLUCENT_NO_FACE_CULL";
        }
    };
    public static ParticleRenderType TERRAIN_SHEET_TRANSLUCENT_NO_FACE_CULL = new ParticleRenderType(){

        @Nullable
        public BufferBuilder begin(Tesselator tesselator, TextureManager textureManager) {
            RenderSystem.depthMask((boolean)true);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_BLOCKS);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableCull();
            RenderSystem.disableDepthTest();
            return tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
        }

        public String toString() {
            return "TERRAIN_SHEET_TRANSLUCENT_NO_FACE_CULL";
        }
    };

    public void tick() {
        --this.despawnCountdown;
        if (this.despawnCountdown <= 0) {
            this.remove();
        }
    }

    public float getColorRed() {
        return this.rCol;
    }

    public float getColorGreen() {
        return this.gCol;
    }

    public float getColorBlue() {
        return this.bCol;
    }

    public void keepAlive() {
        this.despawnCountdown = 40;
    }

    public ParticleRotating(ClientLevel pLevel, double pX, double pY, double pZ) {
        super(pLevel, pX, pY, pZ);
    }

    public void setQuadSize(float size) {
        this.quadSize = size;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public ParticleRenderType getRenderType() {
        return PARTICLE_SHEET_TRANSLUCENT_NO_FACE_CULL;
    }

    public void render(VertexConsumer pBuffer, Camera pRenderInfo, float pPartialTicks) {
        Quaternionf quaternion;
        Vec3 vec3 = pRenderInfo.getPosition();
        float f = (float)(Mth.lerp((double)pPartialTicks, (double)this.xo, (double)this.x) - vec3.x());
        float f1 = (float)(Mth.lerp((double)pPartialTicks, (double)this.yo, (double)this.y) - vec3.y());
        float f2 = (float)(Mth.lerp((double)pPartialTicks, (double)this.zo, (double)this.z) - vec3.z());
        if (this.useCustomRotation) {
            quaternion = new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f);
            quaternion.mul((Quaternionfc)Axis.YP.rotationDegrees(Mth.lerp((float)pPartialTicks, (float)this.prevRotationYaw, (float)this.rotationYaw)));
            quaternion.mul((Quaternionfc)Axis.XP.rotationDegrees(Mth.lerp((float)pPartialTicks, (float)this.prevRotationPitch, (float)this.rotationPitch)));
            quaternion.mul((Quaternionfc)Axis.ZP.rotationDegrees(Mth.lerp((float)pPartialTicks, (float)this.prevRotationRoll, (float)this.rotationRoll)));
        } else if (this.roll == 0.0f) {
            quaternion = pRenderInfo.rotation();
        } else {
            quaternion = new Quaternionf((Quaternionfc)pRenderInfo.rotation());
            quaternion.rotateZ(Mth.lerp((float)pPartialTicks, (float)this.oRoll, (float)this.roll));
        }
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float f3 = this.getQuadSize(pPartialTicks);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.rotate((Quaternionfc)quaternion);
            vector3f.mul(f3);
            vector3f.add(f, f1, f2);
        }
        float u0 = this.getU0();
        float u1 = this.getU1();
        float v0 = this.getV0();
        float v1 = this.getV1();
        int j = this.getLightColor(pPartialTicks);
        pBuffer.addVertex(avector3f[0].x(), avector3f[0].y(), avector3f[0].z()).setUv(u1, v1).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(j);
        pBuffer.addVertex(avector3f[1].x(), avector3f[1].y(), avector3f[1].z()).setUv(u1, v0).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(j);
        pBuffer.addVertex(avector3f[2].x(), avector3f[2].y(), avector3f[2].z()).setUv(u0, v0).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(j);
        pBuffer.addVertex(avector3f[3].x(), avector3f[3].y(), avector3f[3].z()).setUv(u0, v1).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(j);
    }

    public void setPosPrev(double pX, double pY, double pZ) {
        this.xo = pX;
        this.yo = pY;
        this.zo = pZ;
    }

    public float getBrightness() {
        return this.brightness;
    }

    public void setBrightness(float brightness) {
        this.brightness = brightness;
    }
}

