/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.util.packet;

import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.multiloader.S2CPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class MountedToolboxSyncPacket
implements S2CPacket {
    final int id;
    final CompoundTag nbt;

    public MountedToolboxSyncPacket(Entity target, CompoundTag nbt) {
        this.id = target.getId();
        this.nbt = nbt;
    }

    public MountedToolboxSyncPacket(FriendlyByteBuf buf) {
        this.id = buf.readInt();
        this.nbt = buf.readNbt();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.id);
        buffer.writeNbt((Tag)this.nbt);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handle(Minecraft mc) {
        Entity target;
        ClientLevel level = mc.level;
        if (level != null && (target = level.getEntity(this.id)) instanceof ConductorEntity) {
            ConductorEntity conductor = (ConductorEntity)target;
            conductor.getOrCreateToolboxHolder().read(this.nbt, (HolderLookup.Provider)level.registryAccess(), true);
        }
    }
}

