/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.multiloader.neoforge;

import com.railwayteam.railways.Railways;
import com.railwayteam.railways.multiloader.C2SPacket;
import com.railwayteam.railways.multiloader.PacketSet;
import com.railwayteam.railways.multiloader.PlayerSelection;
import com.railwayteam.railways.multiloader.S2CPacket;
import com.railwayteam.railways.multiloader.neoforge.CustomPayloadWrapper;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

public class PacketSetImpl
extends PacketSet {
    public static final Map<ResourceLocation, PacketSet> HANDLERS = new HashMap<ResourceLocation, PacketSet>();

    protected PacketSetImpl(String id, int version, List<Function<FriendlyByteBuf, S2CPacket>> s2cPackets, Object2IntMap<Class<? extends S2CPacket>> s2cTypes, List<Function<FriendlyByteBuf, C2SPacket>> c2sPackets, Object2IntMap<Class<? extends C2SPacket>> c2sTypes) {
        super(id, version, s2cPackets, s2cTypes, c2sPackets, c2sTypes);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerS2CListener() {
        HANDLERS.put(this.s2cPacket, this);
    }

    @Override
    public void registerC2SListener() {
        HANDLERS.put(this.c2sPacket, this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void send(Object packet) {
        throw new UnsupportedOperationException("Create packet forwarding is not wired for NeoForge 21 yet");
    }

    @Override
    public void sendTo(ServerPlayer player, Object packet) {
        throw new UnsupportedOperationException("Create packet forwarding is not wired for NeoForge 21 yet");
    }

    @Override
    public void sendTo(PlayerSelection selection, Object packet) {
        throw new UnsupportedOperationException("Create packet forwarding is not wired for NeoForge 21 yet");
    }

    @Override
    protected void doSendC2S(FriendlyByteBuf buf) {
        ClientPacketListener connection = Minecraft.getInstance().getConnection();
        if (connection != null) {
            CustomPayloadWrapper payload = CustomPayloadWrapper.create(this.c2sPacket, buf);
            connection.send((Packet)new ServerboundCustomPayloadPacket((CustomPacketPayload)payload));
        } else {
            Railways.LOGGER.error("Cannot send a C2S packet before the client connection exists, skipping!");
        }
    }

    @ApiStatus.Internal
    public static PacketSet create(String id, int version, List<Function<FriendlyByteBuf, S2CPacket>> s2cPackets, Object2IntMap<Class<? extends S2CPacket>> s2cTypes, List<Function<FriendlyByteBuf, C2SPacket>> c2sPackets, Object2IntMap<Class<? extends C2SPacket>> c2sTypes) {
        return new PacketSetImpl(id, version, s2cPackets, s2cTypes, c2sPackets, c2sTypes);
    }
}

