/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.multiloader;

import com.railwayteam.railways.compat.Mods;
import com.railwayteam.railways.multiloader.neoforge.LoaderImpl;
import com.railwayteam.railways.util.TextUtils;
import java.util.Locale;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;

public enum Loader {
    FORGE,
    NEOFORGE,
    FABRIC,
    QUILT;

    public static final Loader CURRENT;

    public boolean isCurrent() {
        return this == CURRENT;
    }

    public void runIfCurrent(Supplier<Runnable> run) {
        if (this.isCurrent()) {
            run.get().run();
        }
    }

    public static String getFormatted() {
        return TextUtils.titleCaseConversion(Loader.getActual().name().toLowerCase(Locale.ROOT));
    }

    public static Loader getActual() {
        if (FABRIC.isCurrent() && Mods.isModLoaded("quilt_loader")) {
            return QUILT;
        }
        return CURRENT;
    }

    @ApiStatus.Internal
    private static Loader getCurrent() {
        return LoaderImpl.getCurrent();
    }

    static {
        CURRENT = Loader.getCurrent();
    }
}

