/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin.client;

import com.railwayteam.railways.content.custom_tracks.casing.SlabUseOnCurvePacket;
import com.railwayteam.railways.content.handcar.HandcarItem;
import com.railwayteam.railways.registry.CRPackets;
import com.railwayteam.railways.registry.CRTags;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.railwayteam.railways.util.AdventureUtils;
import com.simibubi.create.content.trains.track.BezierConnection;
import com.simibubi.create.content.trains.track.BezierTrackPointLocation;
import com.simibubi.create.content.trains.track.CurvedTrackInteraction;
import com.simibubi.create.content.trains.track.TrackBlockEntity;
import com.simibubi.create.content.trains.track.TrackBlockOutline;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CurvedTrackInteraction.class}, remap=false)
public abstract class MixinCurvedTrackInteraction {
    @Inject(method={"onClickInput"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;getMainHandItem()Lnet/minecraft/world/item/ItemStack;", remap=true)}, cancellable=true)
    private static void railways$encaseCurve(CallbackInfoReturnable<Boolean> cir) {
        HandcarItem handcar;
        LocalPlayer player = Minecraft.getInstance().player;
        if (AdventureUtils.isAdventure((Player)player)) {
            return;
        }
        ItemStack held = player.getMainHandItem();
        TrackBlockOutline.BezierPointSelection result = TrackBlockOutline.result;
        TrackBlockEntity track = result.blockEntity();
        BezierTrackPointLocation location = result.loc();
        BlockPos curveTarget = location.curveTarget();
        Map connections = track.getConnections();
        BezierConnection connection = connections == null ? null : (BezierConnection)connections.get(curveTarget);
        Item item = held.getItem();
        if (item instanceof HandcarItem && (handcar = (HandcarItem)item).useOnCurve(result, held)) {
            player.swing(InteractionHand.MAIN_HAND);
            cir.setReturnValue((Object)true);
            return;
        }
        if (connection == null || connection.getMaterial().trackType != CRTrackMaterials.CRTrackType.MONORAIL) {
            if (!held.isEmpty()) {
                item = held.getItem();
                if (!(item instanceof BlockItem)) {
                    return;
                }
                BlockItem block = (BlockItem)item;
                Block block2 = block.getBlock();
                if (!(block2 instanceof SlabBlock)) {
                    return;
                }
                SlabBlock slab = (SlabBlock)block2;
                if (CRTags.AllBlockTags.TRACK_CASING_BLACKLIST.matches((Block)slab)) {
                    return;
                }
            }
            CRPackets.PACKETS.send(new SlabUseOnCurvePacket(track.getBlockPos(), curveTarget, BlockPos.containing((Position)result.vec())));
            player.swing(InteractionHand.MAIN_HAND);
            cir.setReturnValue((Object)true);
        }
    }
}

