/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.switches;

import com.railwayteam.railways.content.switches.TrackSwitch;
import com.railwayteam.railways.content.switches.TrackSwitchBlockEntity;
import com.railwayteam.railways.content.switches.neoforge.TrackSwitchBlockImpl;
import com.railwayteam.railways.registry.CRBlockEntities;
import com.railwayteam.railways.registry.CRShapes;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.trains.entity.TravellingPoint;
import com.simibubi.create.foundation.block.IBE;
import net.createmod.catnip.lang.Lang;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TrackSwitchBlock
extends HorizontalDirectionalBlock
implements IBE<TrackSwitchBlockEntity>,
IWrenchable {
    boolean isAutomatic;
    public static final BooleanProperty LOCKED = BlockStateProperties.LOCKED;

    public static TrackSwitchBlock manual(BlockBehaviour.Properties properties) {
        return TrackSwitchBlockImpl.manual(properties);
    }

    public static TrackSwitchBlock automatic(BlockBehaviour.Properties properties) {
        return TrackSwitchBlockImpl.automatic(properties);
    }

    protected TrackSwitchBlock(BlockBehaviour.Properties properties, boolean isAutomatic) {
        super(properties);
        this.isAutomatic = isAutomatic;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)LOCKED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{FACING}).add(new Property[]{LOCKED}));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (state == null) {
            return null;
        }
        return (BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)context.getHorizontalDirection())).setValue((Property)LOCKED, (Comparable)Boolean.valueOf(context.getLevel().hasSignal(context.getClickedPos().below(), Direction.DOWN)));
    }

    public Class<TrackSwitchBlockEntity> getBlockEntityClass() {
        return TrackSwitchBlockEntity.class;
    }

    public BlockEntityType<? extends TrackSwitchBlockEntity> getBlockEntityType() {
        return this.isAutomatic ? (BlockEntityType)CRBlockEntities.BRASS_SWITCH.get() : (BlockEntityType)CRBlockEntities.ANDESITE_SWITCH.get();
    }

    protected boolean isAutomatic() {
        return this.isAutomatic;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        IBE.onRemove((BlockState)state, (Level)level, (BlockPos)pos, (BlockState)newState);
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        EntityCollisionContext entityContext;
        if (context instanceof EntityCollisionContext && (entityContext = (EntityCollisionContext)context).getEntity() instanceof Projectile) {
            return this.isAutomatic ? CRShapes.BRASS_SWITCH_PROJECTILE.get((Direction)state.getValue((Property)FACING)) : CRShapes.ANDESITE_SWITCH_PROJECTILE.get((Direction)state.getValue((Property)FACING));
        }
        return this.isAutomatic ? CRShapes.BRASS_SWITCH.get((Direction)state.getValue((Property)FACING)) : CRShapes.ANDESITE_SWITCH.get((Direction)state.getValue((Property)FACING));
    }

    @NotNull
    public VoxelShape getCollisionShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.hasCollision ? this.getShape(state, level, pos, context) : Shapes.empty();
    }

    public void onProjectileHit(Level level, BlockState state, BlockHitResult hit, Projectile projectile) {
        super.onProjectileHit(level, state, hit, projectile);
        TrackSwitchBlockEntity te = (TrackSwitchBlockEntity)this.getBlockEntity((BlockGetter)level, hit.getBlockPos());
        if (te != null) {
            te.onProjectileHit();
        }
        if (projectile instanceof Arrow) {
            projectile.discard();
        }
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, level, pos, block, fromPos, isMoving);
        TrackSwitchBlockEntity te = (TrackSwitchBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (te != null) {
            te.checkRedstoneInputs();
        }
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hit) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        TrackSwitchBlockEntity te = (TrackSwitchBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (te != null) {
            return te.onUse(player.isShiftKeyDown());
        }
        return InteractionResult.PASS;
    }

    @Deprecated
    public boolean hasAnalogOutputSignal(@NotNull BlockState state) {
        return true;
    }

    @Deprecated
    public int getAnalogOutputSignal(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TrackSwitchBlockEntity) {
            TrackSwitchBlockEntity te = (TrackSwitchBlockEntity)blockEntity;
            return te.getTargetAnalogOutput();
        }
        return 0;
    }

    public static enum SwitchState implements StringRepresentable
    {
        NORMAL(0),
        REVERSE_LEFT(-1),
        REVERSE_RIGHT(1);

        private final int direction;

        private SwitchState(int direction) {
            this.direction = direction;
        }

        public static SwitchState fromSteerDirection(TravellingPoint.SteerDirection direction, boolean forward) {
            return switch (direction) {
                default -> throw new MatchException(null, null);
                case TravellingPoint.SteerDirection.NONE -> NORMAL;
                case TravellingPoint.SteerDirection.LEFT -> {
                    if (forward) {
                        yield REVERSE_LEFT;
                    }
                    yield REVERSE_RIGHT;
                }
                case TravellingPoint.SteerDirection.RIGHT -> forward ? REVERSE_RIGHT : REVERSE_LEFT;
            };
        }

        @NotNull
        public String getSerializedName() {
            return Lang.asId((String)this.name());
        }

        public boolean canSwitchTo(SwitchState next, SwitchConstraint constraint) {
            return switch (constraint.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> true;
                case 2 -> {
                    if (next.direction <= this.direction) {
                        yield true;
                    }
                    yield false;
                }
                case 1 -> next.direction >= this.direction;
            };
        }

        @NotNull
        public SwitchState nextStateFor(TrackSwitch sw, SwitchConstraint constraint) {
            if (this == NORMAL) {
                if (sw.hasRightExit() && constraint.canGoRight()) {
                    return REVERSE_RIGHT;
                }
                if (sw.hasLeftExit() && constraint.canGoLeft()) {
                    return REVERSE_LEFT;
                }
            } else if (this == REVERSE_RIGHT) {
                if (constraint == SwitchConstraint.NONE) {
                    if (sw.hasLeftExit() && constraint.canGoLeft()) {
                        return REVERSE_LEFT;
                    }
                    if (sw.hasStraightExit() && constraint.canGoLeft()) {
                        return NORMAL;
                    }
                } else {
                    if (sw.hasStraightExit() && constraint.canGoLeft()) {
                        return NORMAL;
                    }
                    if (sw.hasLeftExit() && constraint.canGoLeft()) {
                        return REVERSE_LEFT;
                    }
                }
            } else if (this == REVERSE_LEFT) {
                if (sw.hasStraightExit() && constraint.canGoRight()) {
                    return NORMAL;
                }
                if (sw.hasRightExit() && constraint.canGoRight()) {
                    return REVERSE_RIGHT;
                }
            }
            return this;
        }

        public SwitchState nextStateForPonder(SwitchConstraint constraint) {
            if (this == NORMAL) {
                if (constraint.canGoRight()) {
                    return REVERSE_RIGHT;
                }
                if (constraint.canGoLeft()) {
                    return REVERSE_LEFT;
                }
            } else if (this == REVERSE_RIGHT) {
                if (constraint == SwitchConstraint.NONE) {
                    if (constraint.canGoLeft()) {
                        return REVERSE_LEFT;
                    }
                } else if (constraint.canGoLeft()) {
                    return NORMAL;
                }
            } else if (this == REVERSE_LEFT && constraint.canGoRight()) {
                return NORMAL;
            }
            return this;
        }
    }

    public static enum SwitchConstraint {
        NONE,
        TO_RIGHT,
        TO_LEFT;


        public boolean canGoRight() {
            return this != TO_LEFT;
        }

        public boolean canGoLeft() {
            return this != TO_RIGHT;
        }
    }
}

