/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.switches;

import com.railwayteam.railways.content.switches.TrackSwitchBlock;
import com.railwayteam.railways.content.switches.TrackSwitchBlockEntity;
import com.railwayteam.railways.mixin_interfaces.ISwitchDisabledEdge;
import com.railwayteam.railways.registry.CREdgePointTypes;
import com.simibubi.create.Create;
import com.simibubi.create.content.trains.graph.DimensionPalette;
import com.simibubi.create.content.trains.graph.EdgePointType;
import com.simibubi.create.content.trains.graph.TrackEdge;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.content.trains.graph.TrackNode;
import com.simibubi.create.content.trains.graph.TrackNodeLocation;
import com.simibubi.create.content.trains.signal.SignalPropagator;
import com.simibubi.create.content.trains.signal.SingleBlockEntityEdgePoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrackSwitch
extends SingleBlockEntityEdgePoint {
    private TrackNodeLocation switchPoint;
    private final List<TrackNodeLocation> exits = new ArrayList<TrackNodeLocation>();
    private static int selectionPriorityTicker = 0;
    @Nullable
    private TrackNodeLocation straightExit;
    @Nullable
    private TrackNodeLocation leftExit;
    @Nullable
    private TrackNodeLocation rightExit;
    @NotNull
    private TrackSwitchBlock.SwitchState switchState = TrackSwitchBlock.SwitchState.NORMAL;
    private boolean automatic;
    private boolean locked;
    private boolean autoTrainsSwitch;
    private int ticks = 0;
    boolean forceTickClient = false;

    @ApiStatus.Internal
    public static int getSelectionPriority() {
        return ++selectionPriorityTicker;
    }

    public boolean shouldAutoTrainsSwitch() {
        return this.autoTrainsSwitch;
    }

    void setAutoTrainsSwitch(boolean autoTrainsSwitch) {
        this.autoTrainsSwitch = autoTrainsSwitch;
    }

    public boolean isAutomatic() {
        return this.automatic;
    }

    public boolean isLocked() {
        return this.locked;
    }

    void setLocked(boolean locked) {
        this.locked = locked;
    }

    @Nullable
    private TrackNodeLocation getExit(TrackSwitchBlock.SwitchState state) {
        return switch (state) {
            default -> throw new MatchException(null, null);
            case TrackSwitchBlock.SwitchState.NORMAL -> this.straightExit;
            case TrackSwitchBlock.SwitchState.REVERSE_RIGHT -> this.rightExit;
            case TrackSwitchBlock.SwitchState.REVERSE_LEFT -> this.leftExit;
        };
    }

    private Map<TrackSwitchBlock.SwitchState, Optional<TrackNodeLocation>> getExistingExits() {
        return Map.of(TrackSwitchBlock.SwitchState.NORMAL, Optional.ofNullable(this.straightExit), TrackSwitchBlock.SwitchState.REVERSE_LEFT, Optional.ofNullable(this.leftExit), TrackSwitchBlock.SwitchState.REVERSE_RIGHT, Optional.ofNullable(this.rightExit));
    }

    @ApiStatus.Internal
    @Nullable
    public TrackSwitchBlock.SwitchState getTargetState(TrackNodeLocation loc) {
        for (Map.Entry<TrackSwitchBlock.SwitchState, Optional<TrackNodeLocation>> entry : this.getExistingExits().entrySet()) {
            if (!entry.getValue().isPresent() || !entry.getValue().get().equals((Object)loc)) continue;
            return entry.getKey();
        }
        return null;
    }

    public EdgePointType<?> getType() {
        return CREdgePointTypes.SWITCH;
    }

    public boolean canCoexistWith(EdgePointType<?> otherType, boolean front) {
        return otherType == EdgePointType.SIGNAL;
    }

    public void blockEntityAdded(BlockEntity tile, boolean front) {
        super.blockEntityAdded(tile, front);
        if (tile instanceof TrackSwitchBlockEntity) {
            TrackSwitchBlockEntity te = (TrackSwitchBlockEntity)tile;
            te.calculateExits(this);
            this.automatic = te.isAutomatic();
            this.locked = te.isLocked();
        }
        this.notifyTrains(tile.getLevel());
    }

    public void onRemoved(TrackGraph graph) {
        this.exits.clear();
        this.sortExits();
        this.removeFromAllGraphs();
    }

    private void notifyTrains(Level level) {
        TrackGraph graph = Create.RAILWAYS.sided((LevelAccessor)level).getGraph((LevelAccessor)level, (TrackNodeLocation)this.edgeLocation.getFirst());
        if (graph == null) {
            return;
        }
        TrackEdge edge = graph.getConnection(this.edgeLocation.map(arg_0 -> ((TrackGraph)graph).locateNode(arg_0)));
        if (edge == null) {
            return;
        }
        SignalPropagator.notifyTrains((TrackGraph)graph, (TrackEdge[])new TrackEdge[]{edge});
    }

    void updateExits(TrackNodeLocation switchPoint, Collection<TrackNodeLocation> newExits) {
        this.switchPoint = switchPoint;
        if (this.edgeLocation == null) {
            this.exits.clear();
            return;
        }
        Vec3 forward = ((TrackNodeLocation)this.edgeLocation.getFirst()).getLocation().vectorTo(((TrackNodeLocation)this.edgeLocation.getSecond()).getLocation());
        this.exits.clear();
        this.exits.addAll(newExits.stream().filter(e -> forward.dot(switchPoint.getLocation().vectorTo(e.getLocation())) > 0.0).toList());
        this.sortExits();
        this.ensureValidState();
    }

    private void sortExits() {
        Vec3 forward = ((TrackNodeLocation)this.edgeLocation.getFirst()).getLocation().vectorTo(((TrackNodeLocation)this.edgeLocation.getSecond()).getLocation()).normalize();
        this.exits.sort(Comparator.comparing(e -> {
            Vec3 exitDir = this.switchPoint.getLocation().vectorTo(e.getLocation());
            return forward.x * exitDir.z - forward.z * exitDir.x;
        }));
        if (this.exits.size() == 1) {
            this.leftExit = null;
            this.straightExit = this.exits.get(0);
            this.rightExit = null;
        } else if (this.exits.size() == 2) {
            Vec3 firstExitDir = this.switchPoint.getLocation().vectorTo(this.exits.get(0).getLocation()).normalize();
            Vec3 secondExitDir = this.switchPoint.getLocation().vectorTo(this.exits.get(1).getLocation()).normalize();
            double firstExitRelativeDir = forward.x * firstExitDir.z - forward.z * firstExitDir.x;
            double secondExitRelativeDir = forward.x * secondExitDir.z - forward.z * secondExitDir.x;
            double cutoff = 0.2;
            if (firstExitRelativeDir < 0.0 && secondExitRelativeDir <= cutoff) {
                this.leftExit = this.exits.get(0);
                this.straightExit = this.exits.get(1);
                this.rightExit = null;
            } else if (firstExitRelativeDir >= -cutoff && secondExitRelativeDir > 0.0) {
                this.leftExit = null;
                this.straightExit = this.exits.get(0);
                this.rightExit = this.exits.get(1);
            } else {
                this.leftExit = this.exits.get(0);
                this.straightExit = null;
                this.rightExit = this.exits.get(1);
            }
        } else if (this.exits.size() == 3) {
            this.leftExit = this.exits.get(0);
            this.straightExit = this.exits.get(1);
            this.rightExit = this.exits.get(2);
        } else {
            this.leftExit = null;
            this.straightExit = null;
            this.rightExit = null;
        }
    }

    @Nullable
    TrackNodeLocation getSwitchPoint() {
        return this.switchPoint;
    }

    Collection<TrackNodeLocation> getExits() {
        return this.exits.stream().toList();
    }

    private boolean isStateValid(TrackSwitchBlock.SwitchState state) {
        if (state == null) {
            return false;
        }
        return switch (state) {
            default -> throw new MatchException(null, null);
            case TrackSwitchBlock.SwitchState.NORMAL -> this.hasStraightExit();
            case TrackSwitchBlock.SwitchState.REVERSE_RIGHT -> this.hasRightExit();
            case TrackSwitchBlock.SwitchState.REVERSE_LEFT -> this.hasLeftExit();
        };
    }

    private TrackSwitchBlock.SwitchState getValidSwitchState() {
        for (TrackSwitchBlock.SwitchState state : TrackSwitchBlock.SwitchState.values()) {
            if (!this.isStateValid(state)) continue;
            return state;
        }
        return TrackSwitchBlock.SwitchState.NORMAL;
    }

    void ensureValidState() {
        if (!this.isStateValid(this.switchState)) {
            this.switchState = this.getValidSwitchState();
        }
    }

    public boolean trySetSwitchState(@NotNull TrackSwitchBlock.SwitchState state) {
        if (this.isLocked()) {
            return false;
        }
        return this.setSwitchState(state);
    }

    public boolean setSwitchState(@NotNull TrackSwitchBlock.SwitchState state) {
        if (this.isStateValid(state) && this.switchState != state) {
            this.switchState = state;
            this.ticks = 10000;
            this.forceTickClient = true;
            return true;
        }
        return false;
    }

    @NotNull
    public TrackSwitchBlock.SwitchState getSwitchState() {
        return this.switchState;
    }

    @Nullable
    public TrackNodeLocation getSwitchTarget() {
        return switch (this.switchState) {
            default -> throw new MatchException(null, null);
            case TrackSwitchBlock.SwitchState.NORMAL -> this.straightExit;
            case TrackSwitchBlock.SwitchState.REVERSE_RIGHT -> this.rightExit;
            case TrackSwitchBlock.SwitchState.REVERSE_LEFT -> this.leftExit;
        };
    }

    public boolean hasStraightExit() {
        return this.straightExit != null;
    }

    public boolean hasLeftExit() {
        return this.leftExit != null;
    }

    public boolean hasRightExit() {
        return this.rightExit != null;
    }

    public void write(CompoundTag nbt, HolderLookup.Provider provider, DimensionPalette dimensions) {
        super.write(nbt, provider, dimensions);
        nbt.put("SwitchPoint", (Tag)this.switchPoint.write(dimensions));
        nbt.put("Exits", (Tag)NBTHelper.writeCompoundList(this.exits, e -> e.write(dimensions)));
        nbt.putString("SwitchState", this.switchState.getSerializedName());
        nbt.putBoolean("Automatic", this.automatic);
        nbt.putBoolean("Locked", this.locked);
        nbt.putBoolean("AutoTrainsSwitch", this.autoTrainsSwitch);
    }

    public void write(FriendlyByteBuf buffer, DimensionPalette dimensions) {
        super.write(buffer, dimensions);
        buffer.writeInt(this.switchState.ordinal());
        buffer.writeBoolean(this.automatic);
        buffer.writeBoolean(this.locked);
        this.switchPoint.send(buffer, dimensions);
        buffer.writeCollection(this.exits, (buf, e) -> e.send(buf, dimensions));
    }

    public void read(CompoundTag nbt, HolderLookup.Provider provider, boolean migration, DimensionPalette dimensions) {
        super.read(nbt, provider, migration, dimensions);
        String exit = nbt.getString("SwitchState");
        try {
            this.switchState = TrackSwitchBlock.SwitchState.valueOf(exit.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            this.switchState = this.getValidSwitchState();
        }
        this.automatic = nbt.getBoolean("Automatic");
        this.locked = nbt.getBoolean("Locked");
        this.autoTrainsSwitch = nbt.getBoolean("AutoTrainsSwitch");
        this.updateExits(TrackNodeLocation.read((CompoundTag)nbt.getCompound("SwitchPoint"), (DimensionPalette)dimensions), nbt.getList("Exits", 10).stream().map(t -> TrackNodeLocation.read((CompoundTag)((CompoundTag)t), (DimensionPalette)dimensions)).toList());
    }

    public void read(FriendlyByteBuf buffer, DimensionPalette dimensions) {
        super.read(buffer, dimensions);
        this.switchState = TrackSwitchBlock.SwitchState.values()[buffer.readInt()];
        this.automatic = buffer.readBoolean();
        this.locked = buffer.readBoolean();
        this.updateExits(TrackNodeLocation.receive((FriendlyByteBuf)buffer, (DimensionPalette)dimensions), buffer.readList(buf -> TrackNodeLocation.receive((FriendlyByteBuf)buf, (DimensionPalette)dimensions)));
    }

    boolean doForceTickClient() {
        if (this.forceTickClient) {
            this.forceTickClient = false;
            return true;
        }
        return false;
    }

    public void tick(TrackGraph graph, boolean preTrains) {
        super.tick(graph, preTrains);
        if (preTrains) {
            ++this.ticks;
            if (this.ticks < 10) {
                return;
            }
            this.ticks = 0;
            this.updateEdges(graph);
            if (this.automatic) {
                this.switchForEdges(graph);
            }
        }
    }

    public void updateEdges(TrackGraph graph) {
        this.updateEdges(graph, false);
    }

    public void setEdgesActive(TrackGraph graph) {
        this.updateEdges(graph, true);
    }

    private void updateEdges(TrackGraph graph, boolean forceActive) {
        TrackNodeLocation from = this.switchPoint;
        for (TrackNodeLocation to : this.exits) {
            TrackEdge reverseEdge;
            TrackNode toNode;
            Map connections;
            if (to == null || (connections = graph.getConnectionsFrom(toNode = graph.locateNode(to))) == null) continue;
            TrackNode closestFromNode = null;
            TrackEdge closestEdge = null;
            double closestDistance = Double.MAX_VALUE;
            for (Map.Entry otherEnd : connections.entrySet()) {
                double distance = ((TrackNode)otherEnd.getKey()).getLocation().distSqr((Vec3i)from);
                if (!(distance < closestDistance)) continue;
                closestDistance = distance;
                closestEdge = (TrackEdge)otherEnd.getValue();
                closestFromNode = (TrackNode)otherEnd.getKey();
            }
            if (closestEdge != null) {
                ((ISwitchDisabledEdge)closestEdge.getEdgeData()).setEnabled(forceActive || this.getSwitchTarget() == to);
                ((ISwitchDisabledEdge)closestEdge.getEdgeData()).setAutomatic(!forceActive && this.automatic && !this.locked && this.autoTrainsSwitch);
            }
            if (closestFromNode == null || (reverseEdge = graph.getConnection(Couple.create(closestFromNode, (Object)toNode))) == null) continue;
            ((ISwitchDisabledEdge)reverseEdge.getEdgeData()).setEnabled(forceActive || this.getSwitchTarget() == to);
            ((ISwitchDisabledEdge)reverseEdge.getEdgeData()).setAutomatic(!forceActive && this.automatic && !this.locked && this.autoTrainsSwitch);
        }
    }

    private void switchForEdges(TrackGraph graph) {
        TrackNodeLocation from = this.switchPoint;
        TrackNodeLocation highestPriorityExit = null;
        int highestPriority = -100;
        for (TrackNodeLocation to : this.exits) {
            ISwitchDisabledEdge reverseSwitchEdge;
            TrackEdge reverseEdge;
            ISwitchDisabledEdge switchEdge;
            TrackNode toNode;
            Map connections;
            if (to == null || (connections = graph.getConnectionsFrom(toNode = graph.locateNode(to))) == null) continue;
            TrackNode closestFromNode = null;
            TrackEdge closestEdge = null;
            double closestDistance = Double.MAX_VALUE;
            for (Map.Entry otherEnd : connections.entrySet()) {
                double distance = ((TrackNode)otherEnd.getKey()).getLocation().distSqr((Vec3i)from);
                if (!(distance < closestDistance)) continue;
                closestDistance = distance;
                closestEdge = (TrackEdge)otherEnd.getValue();
                closestFromNode = (TrackNode)otherEnd.getKey();
            }
            if (closestEdge != null && (switchEdge = (ISwitchDisabledEdge)closestEdge.getEdgeData()).isAutomaticallySelected()) {
                if (switchEdge.getAutomaticallySelectedPriority() > highestPriority) {
                    highestPriorityExit = to;
                    highestPriority = switchEdge.getAutomaticallySelectedPriority();
                }
                switchEdge.ackAutomaticSelection();
            }
            if (closestFromNode == null || (reverseEdge = graph.getConnection(Couple.create(closestFromNode, (Object)toNode))) == null || !(reverseSwitchEdge = (ISwitchDisabledEdge)reverseEdge.getEdgeData()).isAutomaticallySelected()) continue;
            if (reverseSwitchEdge.getAutomaticallySelectedPriority() > highestPriority) {
                highestPriorityExit = to;
                highestPriority = reverseSwitchEdge.getAutomaticallySelectedPriority();
            }
            reverseSwitchEdge.ackAutomaticSelection();
        }
        if (highestPriorityExit != null) {
            for (TrackSwitchBlock.SwitchState state : TrackSwitchBlock.SwitchState.values()) {
                if (highestPriorityExit != this.getExit(state)) continue;
                this.setSwitchState(state);
                break;
            }
        }
    }
}

