/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.fuel.tank;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.railwayteam.railways.compat.create.MountedFuelTankSyncDeferral;
import com.railwayteam.railways.content.fuel.tank.FuelTankBlockEntity;
import com.railwayteam.railways.mixin.AccessorContraption;
import com.railwayteam.railways.registry.neoforge.CRMountedStorageTypesImpl;
import com.simibubi.create.api.contraption.storage.SyncedMountedStorage;
import com.simibubi.create.api.contraption.storage.fluid.MountedFluidStorageType;
import com.simibubi.create.api.contraption.storage.fluid.WrapperMountedFluidStorage;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import java.util.Objects;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.Nullable;

public class FuelTankMountedStorage
extends WrapperMountedFluidStorage<Handler>
implements SyncedMountedStorage {
    public static final MapCodec<FuelTankMountedStorage> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("capacity").forGetter(FuelTankMountedStorage::getCapacity), (App)FluidStack.lenientOtionalFieldOf((String)"fluid").forGetter(FuelTankMountedStorage::getFluid)).apply((Applicative)i, FuelTankMountedStorage::new));
    private boolean dirty;

    protected FuelTankMountedStorage(int capacity, FluidStack stack) {
        super((MountedFluidStorageType)CRMountedStorageTypesImpl.FUEL_TANK.get(), (IFluidHandler)new Handler(capacity, stack));
        ((Handler)this.wrapped).onChange = () -> {
            this.dirty = true;
        };
    }

    public void unmount(Level level, BlockState state, BlockPos pos, @Nullable BlockEntity be) {
        FuelTankBlockEntity tank;
        if (be instanceof FuelTankBlockEntity && (tank = (FuelTankBlockEntity)be).isController()) {
            FluidTank inventory = tank.getTankInventory();
            inventory.setFluid(((Handler)this.wrapped).getFluid().copy());
        }
    }

    public FluidStack getFluid() {
        return Objects.requireNonNull(((Handler)this.wrapped).getFluid());
    }

    public int getCapacity() {
        return ((Handler)this.wrapped).getCapacity();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void markClean() {
        this.dirty = false;
    }

    public void afterSync(Contraption contraption, BlockPos localPos) {
        AbstractContraptionEntity entity = ((AccessorContraption)contraption).railways$getEntity();
        if (entity == null || entity.level() == null || !entity.level().isClientSide) {
            return;
        }
        BlockEntity be = contraption.getOrCreateClientContraptionLazy().getBlockEntity(localPos);
        if (!(be instanceof FuelTankBlockEntity)) {
            MountedFuelTankSyncDeferral.defer(entity.getId(), localPos, this.getFluid());
            return;
        }
        FuelTankBlockEntity tank = (FuelTankBlockEntity)be;
        FluidTank inv = tank.getTankInventory();
        inv.setFluid(this.getFluid().copy());
        float fillLevel = (float)inv.getFluidAmount() / (float)inv.getCapacity();
        if (tank.getFluidLevel() == null) {
            tank.setFluidLevel(LerpedFloat.linear().startWithValue((double)fillLevel));
        }
        tank.getFluidLevel().chase((double)fillLevel, 0.5, LerpedFloat.Chaser.EXP);
    }

    public static FuelTankMountedStorage fromTank(FuelTankBlockEntity tank) {
        FluidTank inventory = tank.getTankInventory();
        return new FuelTankMountedStorage(inventory.getCapacity(), inventory.getFluid().copy());
    }

    public static FuelTankMountedStorage fromLegacy(CompoundTag nbt) {
        int capacity = nbt.getInt("Capacity");
        FluidStack fluid = FluidStack.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbt).result().orElse(FluidStack.EMPTY);
        return new FuelTankMountedStorage(capacity, fluid);
    }

    public static final class Handler
    extends FluidTank {
        private Runnable onChange = () -> {};

        public Handler(int capacity, FluidStack stack) {
            super(capacity);
            Objects.requireNonNull(stack);
            this.setFluid(stack.copy());
        }

        protected void onContentsChanged() {
            this.onChange.run();
        }
    }
}

