/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_tracks;

import com.railwayteam.railways.mixin_interfaces.IHasTrackCasing;
import com.railwayteam.railways.registry.CRTags;
import com.railwayteam.railways.util.AdventureUtils;
import com.railwayteam.railways.util.EntityUtils;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.trains.track.TrackPropagator;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class CustomTrackBlock {
    @Nullable
    public static InteractionResult casingUse(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        SlabBlock currentCasing;
        SlabBlock slabBlock;
        BlockItem blockItem;
        if (AdventureUtils.isAdventure(player)) {
            return InteractionResult.FAIL;
        }
        ItemStack handStack = player.getItemInHand(hand);
        if (AllItems.BRASS_HAND.isIn(handStack)) {
            TrackPropagator.onRailAdded((LevelAccessor)world, (BlockPos)pos, (BlockState)state);
            return InteractionResult.SUCCESS;
        }
        Item item = handStack.getItem();
        if (item instanceof BlockItem && (item = (blockItem = (BlockItem)item).getBlock()) instanceof SlabBlock && !CRTags.AllBlockTags.TRACK_CASING_BLACKLIST.matches((Block)(slabBlock = (SlabBlock)item))) {
            if (world.isClientSide) {
                return InteractionResult.SUCCESS;
            }
            currentCasing = IHasTrackCasing.getTrackCasing(world, pos);
            if (currentCasing == slabBlock) {
                return IHasTrackCasing.setAlternateModel(world, pos, !IHasTrackCasing.isAlternate(world, pos)) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
            }
            if (!player.isCreative()) {
                handStack.shrink(1);
                player.setItemInHand(hand, handStack);
                if (currentCasing != null) {
                    ItemStack casingStack = new ItemStack((ItemLike)currentCasing);
                    EntityUtils.givePlayerItem(player, casingStack);
                }
            }
            IHasTrackCasing.setTrackCasing(world, pos, slabBlock);
            return InteractionResult.SUCCESS;
        }
        if (handStack.isEmpty() && (currentCasing = IHasTrackCasing.getTrackCasing(world, pos)) != null) {
            if (world.isClientSide) {
                return InteractionResult.SUCCESS;
            }
            handStack = new ItemStack((ItemLike)currentCasing);
            IHasTrackCasing.setTrackCasing(world, pos, null);
            if (!player.isCreative()) {
                EntityUtils.givePlayerItem(player, handStack);
            }
            return InteractionResult.SUCCESS;
        }
        return null;
    }
}

