/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_bogeys.renderer.standard;

import com.railwayteam.railways.content.custom_bogeys.renderer.unified.BogeyDisplay;
import com.railwayteam.railways.content.custom_bogeys.renderer.unified.ElementProvider;
import com.railwayteam.railways.content.handcar.ik.DoubleArmIK;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import dev.engine_room.flywheel.lib.transform.Affine;
import net.createmod.catnip.data.Iterate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class HandcarBogeyDisplay
implements BogeyDisplay.EntityAware {
    private final Affine<?>[] wheels;
    private final Affine<?> coupling;
    private final Affine<?> frame;
    private final Affine<?> handle;
    private final Affine<?> handleFirstPerson;
    private final Affine<?> largeCog;
    private final Affine<?> smallCog;
    private boolean firstPerson = false;

    public HandcarBogeyDisplay(ElementProvider<?> prov) {
        this.wheels = prov.create(CRBlockPartials.HANDCAR_WHEELS, 2);
        this.coupling = prov.create(CRBlockPartials.HANDCAR_COUPLING);
        this.frame = prov.create(CRBlockPartials.HANDCAR_FRAME);
        this.handle = prov.create(CRBlockPartials.HANDCAR_HANDLE);
        this.handleFirstPerson = prov.create(CRBlockPartials.HANDCAR_HANDLE_FIRST_PERSON);
        this.largeCog = prov.create(CRBlockPartials.HANDCAR_LARGE_COG);
        this.smallCog = prov.create(CRBlockPartials.HANDCAR_SMALL_COG);
    }

    @Override
    public void entityUpdate(CarriageContraptionEntity cce) {
        this.firstPerson = false;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null || !mc.options.getCameraType().isFirstPerson()) {
            return;
        }
        this.firstPerson = player.getRootVehicle() == cce;
    }

    @Override
    public void update(CompoundTag bogeyData, float wheelAngle) {
        this.frame.translate(0.0f, 0.3125f, 0.0f);
        double couple_r = 0.1875 * (double)Mth.SQRT_OF_TWO;
        double couple_degrees = (double)(-(wheelAngle *= 2.0f) / 2.0f) - 22.5;
        float couple_radians = (float)(couple_degrees * 0.01745329238474369);
        double couple_x = couple_r * (double)Mth.sin((float)couple_radians);
        double couple_y = couple_r * (double)Mth.cos((float)couple_radians);
        Vec3 coupling_pos = new Vec3(0.109375, 0.75 + couple_y, -0.21875 + couple_x);
        Vec2 upperVec2 = new Vec2(0.0f, 2.4375f);
        Vec2 couplingVec2 = new Vec2((float)coupling_pos.z, (float)coupling_pos.y);
        Vec2 hingeOffset = DoubleArmIK.calculateJointOffset(upperVec2, couplingVec2, 0.875, 1.125);
        Vec2 hingePos2 = hingeOffset.add(couplingVec2);
        double couplingAngle = Mth.atan2((double)hingeOffset.y, (double)hingeOffset.x);
        Vec2 handle_offset = hingePos2.add(upperVec2.negated());
        double handleAngle = Mth.atan2((double)handle_offset.y, (double)handle_offset.x);
        ((Affine)((Affine)((Affine)((Affine)this.handle.translateY(2.4375f)).rotateZDegrees(180.0f)).rotateX((float)(handleAngle - Math.toRadians(57.5)))).translateY(-2.125f)).scale(this.firstPerson ? 0.0f : 1.0f);
        ((Affine)((Affine)((Affine)((Affine)this.handleFirstPerson.translateY(2.4375f)).rotateZDegrees(180.0f)).rotateX((float)(handleAngle - Math.toRadians(57.5)))).translateY(-2.125f)).scale(this.firstPerson ? 1.0f : 0.0f);
        ((Affine)this.coupling.translate(coupling_pos)).rotateX((float)(-(couplingAngle - 1.5707963705062866)));
        ((Affine)((Affine)((Affine)this.largeCog.translate(-0.5, 0.75, -0.21875)).rotateXDegrees(-wheelAngle / 2.0f + 22.5f)).rotateZDegrees(90.0f)).translate(0.0f, -0.4375f, 0.0f);
        ((Affine)((Affine)((Affine)this.smallCog.translate(-0.5f, 0.75f, -1.0f)).rotateXDegrees(wheelAngle)).rotateZDegrees(90.0f)).translate(0.0f, -0.4375f, 0.0f);
        for (int side : Iterate.positiveAndNegative) {
            ((Affine)((Affine)this.wheels[(side + 1) / 2].translate(0.0f, 0.75f, (float)side)).rotateXDegrees(wheelAngle)).translate(0.0f, -0.75f, 0.0f);
        }
    }
}

