/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.coupling.coupler;

import com.railwayteam.railways.mixin.AccessorTrackTargetingBehavior;
import com.simibubi.create.content.trains.graph.EdgePointType;
import com.simibubi.create.content.trains.signal.TrackEdgePoint;
import com.simibubi.create.content.trains.track.BezierTrackPointLocation;
import com.simibubi.create.content.trains.track.TrackTargetingBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import java.util.UUID;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.phys.Vec3;

public class SecondaryTrackTargetingBehaviour<T extends TrackEdgePoint>
extends TrackTargetingBehaviour<T> {
    public static final BehaviourType<SecondaryTrackTargetingBehaviour<?>> TYPE = new BehaviourType();

    public SecondaryTrackTargetingBehaviour(SmartBlockEntity te, EdgePointType<T> edgePointType) {
        super(te, edgePointType);
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }

    public void write(CompoundTag nbt, HolderLookup.Provider lookupProvider, boolean clientPacket) {
        AccessorTrackTargetingBehavior accessor = (AccessorTrackTargetingBehavior)((Object)this);
        nbt.putUUID("SecondaryId", accessor.getId());
        nbt.put("SecondaryTargetTrack", NbtUtils.writeBlockPos((BlockPos)accessor.getTargetTrack()));
        nbt.putBoolean("SecondaryOrtho", accessor.isOrthogonal());
        nbt.putBoolean("SecondaryTargetDirection", accessor.getTargetDirection() == Direction.AxisDirection.POSITIVE);
        if (accessor.getRotatedDirection() != null) {
            nbt.put("SecondaryRotatedAxis", (Tag)VecHelper.writeNBT((Vec3)accessor.getRotatedDirection()));
        }
        if (accessor.getPrevDirection() != null) {
            nbt.put("SecondaryPrevAxis", (Tag)VecHelper.writeNBT((Vec3)accessor.getPrevDirection()));
        }
        if (accessor.getMigrationData() != null && !clientPacket) {
            nbt.put("SecondaryMigrate", (Tag)accessor.getMigrationData());
        }
        if (accessor.getTargetBezier() != null) {
            CompoundTag bezierNbt = new CompoundTag();
            bezierNbt.putInt("Segment", accessor.getTargetBezier().segment());
            bezierNbt.put("Key", NbtUtils.writeBlockPos((BlockPos)accessor.getTargetBezier().curveTarget().subtract((Vec3i)this.getPos())));
            nbt.put("SecondaryBezier", (Tag)bezierNbt);
        }
    }

    public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider, boolean clientPacket) {
        AccessorTrackTargetingBehavior accessor = (AccessorTrackTargetingBehavior)((Object)this);
        accessor.setId(nbt.contains("SecondaryId") ? nbt.getUUID("SecondaryId") : UUID.randomUUID());
        accessor.setTargetTrack(NbtUtils.readBlockPos((CompoundTag)nbt, (String)"SecondaryTargetTrack").orElse(this.getPos()));
        accessor.setTargetDirection(nbt.getBoolean("SecondaryTargetDirection") ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE);
        accessor.setOrthogonal(nbt.getBoolean("SecondaryOrtho"));
        if (nbt.contains("SecondaryPrevAxis")) {
            accessor.setPrevDirection(VecHelper.readNBT((ListTag)nbt.getList("SecondaryPrevAxis", 6)));
        }
        if (nbt.contains("SecondaryRotatedAxis")) {
            accessor.setRotatedDirection(VecHelper.readNBT((ListTag)nbt.getList("SecondaryRotatedAxis", 6)));
        }
        if (nbt.contains("SecondaryMigrate")) {
            accessor.setMigrationData(nbt.getCompound("SecondaryMigrate"));
        }
        if (clientPacket) {
            accessor.setEdgePoint(null);
        }
        if (nbt.contains("SecondaryBezier")) {
            CompoundTag bezierNbt = nbt.getCompound("SecondaryBezier");
            BlockPos key = NbtUtils.readBlockPos((CompoundTag)bezierNbt, (String)"Key").orElse(this.getPos());
            accessor.setTargetBezier(new BezierTrackPointLocation(bezierNbt.contains("FromStack") ? key : key.offset((Vec3i)this.getPos()), bezierNbt.getInt("Segment")));
        }
    }
}

