/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.conductor.toolbox;

import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.content.conductor.toolbox.MountedToolbox;
import com.railwayteam.railways.content.conductor.toolbox.neoforge.MountedToolboxDisposeAllPacketImpl;
import com.railwayteam.railways.multiloader.C2SPacket;
import com.simibubi.create.content.equipment.toolbox.ToolboxHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class MountedToolboxDisposeAllPacket
implements C2SPacket {
    private final int toolboxCarrierId;

    public MountedToolboxDisposeAllPacket(ConductorEntity toolboxCarrier) {
        this.toolboxCarrierId = toolboxCarrier.getId();
    }

    public MountedToolboxDisposeAllPacket(FriendlyByteBuf buffer) {
        this.toolboxCarrierId = buffer.readInt();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.toolboxCarrierId);
    }

    @Override
    public void handle(ServerPlayer player) {
        Level world = player.level();
        Entity entity = world.getEntity(this.toolboxCarrierId);
        if (entity instanceof ConductorEntity) {
            ConductorEntity conductorEntity = (ConductorEntity)entity;
            double maxRange = ToolboxHandler.getMaxRange((Player)player);
            if (player.distanceToSqr((Entity)conductorEntity) > maxRange * maxRange) {
                return;
            }
            MountedToolbox toolbox = conductorEntity.getToolbox();
            if (toolbox == null) {
                return;
            }
            boolean sendData = MountedToolboxDisposeAllPacket.doDisposal(toolbox, player, conductorEntity);
            if (sendData) {
                ToolboxHandler.syncData((Player)player);
            }
        }
    }

    public static boolean doDisposal(MountedToolbox toolbox, ServerPlayer player, ConductorEntity conductor) {
        return MountedToolboxDisposeAllPacketImpl.doDisposal(toolbox, player, conductor);
    }
}

