/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.buffer.headstock;

import com.railwayteam.railways.content.buffer.IDyedBuffer;
import com.railwayteam.railways.util.BlockStateUtils;
import com.simibubi.create.content.decoration.copycat.CopycatBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class CopycatHeadstockBlockEntity
extends CopycatBlockEntity
implements IDyedBuffer {
    @Nullable
    protected DyeColor color;

    public CopycatHeadstockBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    @Nullable
    public DyeColor getColor() {
        return this.color;
    }

    protected void write(CompoundTag tag, HolderLookup.Provider provider, boolean clientPacket) {
        super.write(tag, provider, clientPacket);
        if (this.color != null) {
            tag.putInt("Color", this.color.getId());
        }
    }

    protected void read(CompoundTag tag, HolderLookup.Provider provider, boolean clientPacket) {
        super.read(tag, provider, clientPacket);
        DyeColor prevColor = this.color;
        this.color = tag.contains("Color") ? DyeColor.byId((int)tag.getInt("Color")) : null;
        if (clientPacket && prevColor != this.color) {
            this.redrawColor();
        }
    }

    protected void redrawColor() {
        if (this.hasLevel()) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 16);
            this.level.getChunkSource().getLightEngine().checkBlock(this.worldPosition);
        }
    }

    public InteractionResult applyDyeIfValid(ItemStack stack) {
        Item item = stack.getItem();
        if (!(item instanceof DyeItem)) {
            return InteractionResult.PASS;
        }
        DyeItem dyeItem = (DyeItem)item;
        DyeColor color = dyeItem.getDyeColor();
        if (color == this.color) {
            return InteractionResult.PASS;
        }
        if (this.level.isClientSide() && !this.isVirtual()) {
            return InteractionResult.SUCCESS;
        }
        this.color = color;
        this.notifyUpdate();
        this.level.levelEvent(2001, this.worldPosition, Block.getId((BlockState)BlockStateUtils.getWoolBlock(color).defaultBlockState()));
        return InteractionResult.SUCCESS;
    }
}

