/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.base.datafixerapi;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.schemas.Schema;
import com.railwayteam.railways.Railways;
import com.railwayteam.railways.base.datafixerapi.DataFixesInternalsImpl;
import com.railwayteam.railways.base.datafixerapi.NoOpDataFixesInternals;
import java.util.function.BiFunction;
import net.minecraft.SharedConstants;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.util.datafix.DataFixers;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

@ApiStatus.Internal
public abstract class DataFixesInternals {
    public static final BiFunction<Integer, Schema, Schema> BASE_SCHEMA = (version, parent) -> {
        Preconditions.checkArgument((version == 0 ? 1 : 0) != 0, (Object)"version must be 0");
        Preconditions.checkArgument((parent == null ? 1 : 0) != 0, (Object)"parent must be null");
        return DataFixesInternals.get().createBaseSchema();
    };
    private static DataFixesInternals instance;

    @Contract(pure=true)
    public static @Range(from=0L, to=0x7FFFFFFFL) int getModDataVersion(@NotNull CompoundTag compound) {
        return compound.getInt("Railways_DataVersion");
    }

    @NotNull
    public static DataFixesInternals get() {
        if (instance == null) {
            Schema latestVanillaSchema;
            try {
                latestVanillaSchema = DataFixers.getDataFixer().getSchema(DataFixUtils.makeKey((int)SharedConstants.getCurrentVersion().getDataVersion().getVersion()));
            }
            catch (Exception e) {
                latestVanillaSchema = null;
            }
            if (latestVanillaSchema == null) {
                Railways.LOGGER.warn("[Railways DFU] Failed to initialize! Either someone stopped DFU from initializing,");
                Railways.LOGGER.warn("[Railways DFU] or this Minecraft build is hosed.");
                Railways.LOGGER.warn("[Railways DFU] Using no-op implementation.");
                instance = new NoOpDataFixesInternals();
            } else {
                instance = new DataFixesInternalsImpl(latestVanillaSchema);
            }
        }
        return instance;
    }

    public abstract void registerFixer(@Range(from=0L, to=0x7FFFFFFFL) int var1, @NotNull DataFixer var2);

    @Nullable
    public abstract DataFixerEntry getFixerEntry();

    @Contract(value="-> new", pure=true)
    @NotNull
    public abstract Schema createBaseSchema();

    @NotNull
    public abstract CompoundTag updateWithAllFixers(@NotNull DataFixTypes var1, @NotNull CompoundTag var2);

    @NotNull
    public abstract CompoundTag addModDataVersions(@NotNull CompoundTag var1);

    public record DataFixerEntry(DataFixer dataFixer, int currentVersion) {
    }
}

