/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.data;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.p3pp3rf1y.sophisticatedstorage.data.CopyStorageDataFunction;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;

public class StorageBlockLootProvider
extends LootTableProvider {
    StorageBlockLootProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registries) {
        super(packOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(SubProvider::new, LootContextParamSets.BLOCK)), registries);
    }

    private static class SubProvider
    extends BlockLootSubProvider {
        protected SubProvider(HolderLookup.Provider registries) {
            super(Set.of(), FeatureFlags.REGISTRY.allFlags(), registries);
        }

        public void generate() {
            this.add((Block)ModBlocks.BARREL.get(), SubProvider.dropStorageWithContents((Item)ModBlocks.BARREL_ITEM.get()));
            this.add((Block)ModBlocks.COPPER_BARREL.get(), SubProvider.dropStorageWithContents((Item)ModBlocks.COPPER_BARREL_ITEM.get()));
            this.add((Block)ModBlocks.IRON_BARREL.get(), SubProvider.dropStorageWithContents((Item)ModBlocks.IRON_BARREL_ITEM.get()));
            this.add((Block)ModBlocks.GOLD_BARREL.get(), SubProvider.dropStorageWithContents((Item)ModBlocks.GOLD_BARREL_ITEM.get()));
            this.add((Block)ModBlocks.DIAMOND_BARREL.get(), SubProvider.dropStorageWithContents((Item)ModBlocks.DIAMOND_BARREL_ITEM.get()));
            this.add((Block)ModBlocks.NETHERITE_BARREL.get(), SubProvider.dropStorageWithContents((Item)ModBlocks.NETHERITE_BARREL_ITEM.get()));
            this.add((Block)ModBlocks.LIMITED_BARREL_1.get(), SubProvider.dropStorageWithContents((Item)ModBlocks.LIMITED_BARREL_1_ITEM.get()));
            this.add((Block)ModBlocks.LIMITED_COPPER_BARREL_1.get(), SubProvider.dropStorageWithContents((Item)ModBlocks.LIMITED_COPPER_BARREL_1_ITEM.get()));
            this.add((Block)ModBlocks.LIMITED_IRON_BARREL_1.get(), SubProvider.dropStorageWithContents((Item)ModBlocks.LIMITED_IRON_BARREL_1_ITEM.get()));
            this.add((Block)ModBlocks.LIMITED_GOLD_BARREL_1.get(), SubProvider.dropStorageWithContents((Item)ModBlocks.LIMITED_GOLD_BARREL_1_ITEM.get()));
            this.add((Block)ModBlocks.LIMITED_DIAMOND_BARREL_1.get(), SubProvider.dropStorageWithContents((Item)ModBlocks.LIMITED_DIAMOND_BARREL_1_ITEM.get()));
            this.add((Block)ModBlocks.LIMITED_NETHERITE_BARREL_1.get(), SubProvider.dropStorageWithContents((Item)ModBlocks.LIMITED_NETHERITE_BARREL_1_ITEM.get()));
            this.add((Block)ModBlocks.LIMITED_BARREL_2.get(), SubProvider.dropStorageWithContents((Item)ModBlocks.LIMITED_BARREL_2_ITEM.get()));
            this.add((Block)ModBlocks.LIMITED_COPPER_BARREL_2.get(), SubProvider.dropStorageWithContents((Item)ModBlocks.LIMITED_COPPER_BARREL_2_ITEM.get()));
            this.add((Block)ModBlocks.LIMITED_IRON_BARREL_2.get(), SubProvider.dropStorageWithContents((Item)ModBlocks.LIMITED_IRON_BARREL_2_ITEM.get()));
            this.add((Block)ModBlocks.LIMITED_GOLD_BARREL_2.get(), SubProvider.dropStorageWithContents((Item)ModBlocks.LIMITED_GOLD_BARREL_2_ITEM.get()));
            this.add((Block)ModBlocks.LIMITED_DIAMOND_BARREL_2.get(), SubProvider.dropStorageWithContents((Item)ModBlocks.LIMITED_DIAMOND_BARREL_2_ITEM.get()));
            this.add((Block)ModBlocks.LIMITED_NETHERITE_BARREL_2.get(), SubProvider.dropStorageWithContents((Item)ModBlocks.LIMITED_NETHERITE_BARREL_2_ITEM.get()));
            this.add((Block)ModBlocks.LIMITED_BARREL_3.get(), SubProvider.dropStorageWithContents((Item)ModBlocks.LIMITED_BARREL_3_ITEM.get()));
            this.add((Block)ModBlocks.LIMITED_COPPER_BARREL_3.get(), SubProvider.dropStorageWithContents((Item)ModBlocks.LIMITED_COPPER_BARREL_3_ITEM.get()));
            this.add((Block)ModBlocks.LIMITED_IRON_BARREL_3.get(), SubProvider.dropStorageWithContents((Item)ModBlocks.LIMITED_IRON_BARREL_3_ITEM.get()));
            this.add((Block)ModBlocks.LIMITED_GOLD_BARREL_3.get(), SubProvider.dropStorageWithContents((Item)ModBlocks.LIMITED_GOLD_BARREL_3_ITEM.get()));
            this.add((Block)ModBlocks.LIMITED_DIAMOND_BARREL_3.get(), SubProvider.dropStorageWithContents((Item)ModBlocks.LIMITED_DIAMOND_BARREL_3_ITEM.get()));
            this.add((Block)ModBlocks.LIMITED_NETHERITE_BARREL_3.get(), SubProvider.dropStorageWithContents((Item)ModBlocks.LIMITED_NETHERITE_BARREL_3_ITEM.get()));
            this.add((Block)ModBlocks.LIMITED_BARREL_4.get(), SubProvider.dropStorageWithContents((Item)ModBlocks.LIMITED_BARREL_4_ITEM.get()));
            this.add((Block)ModBlocks.LIMITED_COPPER_BARREL_4.get(), SubProvider.dropStorageWithContents((Item)ModBlocks.LIMITED_COPPER_BARREL_4_ITEM.get()));
            this.add((Block)ModBlocks.LIMITED_IRON_BARREL_4.get(), SubProvider.dropStorageWithContents((Item)ModBlocks.LIMITED_IRON_BARREL_4_ITEM.get()));
            this.add((Block)ModBlocks.LIMITED_GOLD_BARREL_4.get(), SubProvider.dropStorageWithContents((Item)ModBlocks.LIMITED_GOLD_BARREL_4_ITEM.get()));
            this.add((Block)ModBlocks.LIMITED_DIAMOND_BARREL_4.get(), SubProvider.dropStorageWithContents((Item)ModBlocks.LIMITED_DIAMOND_BARREL_4_ITEM.get()));
            this.add((Block)ModBlocks.LIMITED_NETHERITE_BARREL_4.get(), SubProvider.dropStorageWithContents((Item)ModBlocks.LIMITED_NETHERITE_BARREL_4_ITEM.get()));
            this.add((Block)ModBlocks.CHEST.get(), SubProvider.dropStorageWithContents((Item)ModBlocks.CHEST_ITEM.get()));
            this.add((Block)ModBlocks.COPPER_CHEST.get(), SubProvider.dropStorageWithContents((Item)ModBlocks.COPPER_CHEST_ITEM.get()));
            this.add((Block)ModBlocks.IRON_CHEST.get(), SubProvider.dropStorageWithContents((Item)ModBlocks.IRON_CHEST_ITEM.get()));
            this.add((Block)ModBlocks.GOLD_CHEST.get(), SubProvider.dropStorageWithContents((Item)ModBlocks.GOLD_CHEST_ITEM.get()));
            this.add((Block)ModBlocks.DIAMOND_CHEST.get(), SubProvider.dropStorageWithContents((Item)ModBlocks.DIAMOND_CHEST_ITEM.get()));
            this.add((Block)ModBlocks.NETHERITE_CHEST.get(), SubProvider.dropStorageWithContents((Item)ModBlocks.NETHERITE_CHEST_ITEM.get()));
            this.add((Block)ModBlocks.SHULKER_BOX.get(), SubProvider.dropStorageWithContents((Item)ModBlocks.SHULKER_BOX_ITEM.get()));
            this.add((Block)ModBlocks.COPPER_SHULKER_BOX.get(), SubProvider.dropStorageWithContents((Item)ModBlocks.COPPER_SHULKER_BOX_ITEM.get()));
            this.add((Block)ModBlocks.IRON_SHULKER_BOX.get(), SubProvider.dropStorageWithContents((Item)ModBlocks.IRON_SHULKER_BOX_ITEM.get()));
            this.add((Block)ModBlocks.GOLD_SHULKER_BOX.get(), SubProvider.dropStorageWithContents((Item)ModBlocks.GOLD_SHULKER_BOX_ITEM.get()));
            this.add((Block)ModBlocks.DIAMOND_SHULKER_BOX.get(), SubProvider.dropStorageWithContents((Item)ModBlocks.DIAMOND_SHULKER_BOX_ITEM.get()));
            this.add((Block)ModBlocks.NETHERITE_SHULKER_BOX.get(), SubProvider.dropStorageWithContents((Item)ModBlocks.NETHERITE_SHULKER_BOX_ITEM.get()));
            this.add((Block)ModBlocks.CONTROLLER.get(), this.dropBlock((ItemLike)ModBlocks.CONTROLLER_ITEM.get()));
            this.add((Block)ModBlocks.STORAGE_LINK.get(), this.dropBlock((ItemLike)ModBlocks.STORAGE_LINK_ITEM.get()));
            this.add((Block)ModBlocks.STORAGE_IO.get(), this.dropBlock((ItemLike)ModBlocks.STORAGE_IO_ITEM.get()));
            this.add((Block)ModBlocks.STORAGE_INPUT.get(), this.dropBlock((ItemLike)ModBlocks.STORAGE_INPUT_ITEM.get()));
            this.add((Block)ModBlocks.STORAGE_OUTPUT.get(), this.dropBlock((ItemLike)ModBlocks.STORAGE_OUTPUT_ITEM.get()));
            ModBlocks.STORAGE_CONNECTOR_BLOCKS.forEach((woodType, blockSupplier) -> this.add((Block)blockSupplier.get(), this.dropBlock((ItemLike)ModBlocks.STORAGE_CONNECTOR_ITEMS.get(woodType).get())));
            this.add((Block)ModBlocks.DECORATION_TABLE.get(), this.dropBlock((ItemLike)ModBlocks.DECORATION_TABLE_ITEM.get()));
        }

        protected Iterable<Block> getKnownBlocks() {
            return BuiltInRegistries.BLOCK.entrySet().stream().filter(e -> ((ResourceKey)e.getKey()).location().getNamespace().equals("sophisticatedstorage")).map(Map.Entry::getValue).toList();
        }

        private static LootTable.Builder dropStorageWithContents(Item storageItem) {
            LootPool.Builder pool = LootPool.lootPool().name("main").setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)storageItem)).apply((LootItemFunction.Builder)CopyNameFunction.copyName((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).apply((LootItemFunction.Builder)CopyStorageDataFunction.builder());
            return LootTable.lootTable().withPool(pool);
        }

        public LootTable.Builder dropBlock(ItemLike item) {
            return LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionCondition(item, (ConditionUserBuilder)LootPool.lootPool().name("main").setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item))));
        }
    }
}

