/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.escalated.walkways;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.simpleRelays.ShaftBlock;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import rbasamoyai.escalated.index.EscalatedShapes;
import rbasamoyai.escalated.walkways.AbstractWalkwayBlock;
import rbasamoyai.escalated.walkways.NarrowWalkwayBlock;
import rbasamoyai.escalated.walkways.WalkwayCaps;
import rbasamoyai.escalated.walkways.WalkwaySet;
import rbasamoyai.escalated.walkways.WalkwaySlope;
import rbasamoyai.escalated.walkways.WideWalkwayCenterBlock;

public class WideWalkwaySideBlock
extends AbstractWalkwayBlock {
    public static final BooleanProperty LEFT = BooleanProperty.create((String)"left");

    public WideWalkwaySideBlock(BlockBehaviour.Properties properties, NonNullSupplier<WalkwaySet> walkwaySetSupplier) {
        super(properties, walkwaySetSupplier);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)CAPS_SIDED, (Comparable)((Object)WalkwayCaps.NO_SHAFT)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{LEFT, CAPS_SIDED});
    }

    @Override
    public WalkwaySlope getWalkwaySlope(BlockState state) {
        return WalkwaySlope.HORIZONTAL;
    }

    @Override
    public boolean hasWalkwayShaft(BlockState state) {
        return state.getValue((Property)CAPS_SIDED) != WalkwayCaps.NO_SHAFT;
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        Direction facing = (Direction)state.getValue(HORIZONTAL_FACING);
        facing = (Boolean)state.getValue((Property)LEFT) != false ? facing.getCounterClockWise() : facing.getClockWise();
        return state.getValue((Property)CAPS_SIDED) == WalkwayCaps.NONE && face == facing;
    }

    protected boolean areStatesKineticallyEquivalent(BlockState oldState, BlockState newState) {
        return super.areStatesKineticallyEquivalent(oldState, newState) && oldState.getValue((Property)CAPS_SIDED) == newState.getValue((Property)CAPS_SIDED) && oldState.getValue((Property)LEFT) == newState.getValue((Property)LEFT);
    }

    @Override
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (player.isShiftKeyDown() || !player.mayBuild()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (AllBlocks.SHAFT.isIn(stack)) {
            if (state.getValue((Property)CAPS_SIDED) != WalkwayCaps.NO_SHAFT) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            if (level.isClientSide) {
                return ItemInteractionResult.SUCCESS;
            }
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)pos, (BlockState)((BlockState)state.setValue((Property)CAPS_SIDED, (Comparable)((Object)WalkwayCaps.NONE))));
            ((ShaftBlock)AllBlocks.SHAFT.get()).playEncaseSound(level, pos);
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        Direction shaftFacing;
        Level level = context.getLevel();
        BlockState newState = state;
        Direction facing = (Direction)state.getValue(HORIZONTAL_FACING);
        Direction clicked = context.getClickedFace();
        WalkwayCaps caps = (WalkwayCaps)((Object)state.getValue((Property)CAPS_SIDED));
        if (caps == WalkwayCaps.NO_SHAFT) {
            return InteractionResult.PASS;
        }
        Direction direction = shaftFacing = (Boolean)state.getValue((Property)LEFT) != false ? facing.getCounterClockWise() : facing.getClockWise();
        if (clicked == shaftFacing) {
            caps = caps == WalkwayCaps.NONE ? WalkwayCaps.BOTH : WalkwayCaps.NONE;
        }
        newState = (BlockState)newState.setValue((Property)CAPS_SIDED, (Comparable)((Object)caps));
        KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)context.getClickedPos(), (BlockState)this.updateAfterWrenched(newState, context));
        BlockState setState = level.getBlockState(context.getClickedPos());
        if (setState != state) {
            AllSoundEvents.WRENCH_REMOVE.playOnServer(level, (Vec3i)context.getClickedPos(), 1.0f, level.random.nextFloat() * 0.5f + 0.5f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        if (state.getValue((Property)CAPS_SIDED) != WalkwayCaps.NO_SHAFT) {
            if (level.isClientSide) {
                return InteractionResult.SUCCESS;
            }
            if (player != null && !player.isCreative()) {
                player.getInventory().placeItemBackInInventory(AllBlocks.SHAFT.asStack());
            }
            KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)pos, (BlockState)((BlockState)state.setValue((Property)CAPS_SIDED, (Comparable)((Object)WalkwayCaps.NO_SHAFT))));
            AllSoundEvents.WRENCH_REMOVE.playOnServer(level, (Vec3i)pos, 1.0f, level.random.nextFloat() * 0.5f + 0.5f);
            return InteractionResult.SUCCESS;
        }
        return super.onSneakWrenched(state, context);
    }

    @Override
    public BlockState transformFromMerge(Level level, BlockState state, BlockPos pos, boolean left, boolean shaft, boolean remove, boolean replace) {
        WalkwayCaps caps = (WalkwayCaps)((Object)state.getValue((Property)CAPS_SIDED));
        if (shaft && caps == WalkwayCaps.NO_SHAFT) {
            caps = WalkwayCaps.NONE;
        } else if (!shaft) {
            caps = WalkwayCaps.NO_SHAFT;
        }
        state = (BlockState)state.setValue((Property)CAPS_SIDED, (Comparable)((Object)caps));
        boolean srcLeft = (Boolean)state.getValue((Property)LEFT);
        Direction facing = (Direction)state.getValue(HORIZONTAL_FACING);
        if (remove) {
            if (srcLeft == left) {
                return state;
            }
            return (BlockState)((BlockState)this.getWalkwaySet().getNarrowBlock(level, state, pos).setValue(HORIZONTAL_FACING, (Comparable)facing)).setValue((Property)NarrowWalkwayBlock.CAPS, (Comparable)((Object)caps));
        }
        if (srcLeft != left) {
            return state;
        }
        return (BlockState)((BlockState)this.getWalkwaySet().getWideCenterBlock(level, state, pos).setValue(HORIZONTAL_FACING, (Comparable)facing)).setValue((Property)WideWalkwayCenterBlock.SHAFT, (Comparable)Boolean.valueOf(shaft));
    }

    @Override
    public boolean connectedToWalkwayOnSide(Level level, BlockState state, BlockPos pos, Direction face) {
        Direction facing = (Direction)state.getValue(HORIZONTAL_FACING);
        if (face.getAxis() == facing.getAxis()) {
            return true;
        }
        Direction openFace = (Boolean)state.getValue((Property)LEFT) != false ? facing.getClockWise() : facing.getCounterClockWise();
        return face == openFace;
    }

    @Override
    public boolean isEscalator(Level level, BlockState state, BlockPos pos) {
        return false;
    }

    public VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.getValue(HORIZONTAL_FACING);
        return (Boolean)state.getValue((Property)LEFT) != false ? EscalatedShapes.WIDE_WALKWAY_SIDE_LEFT.get(facing) : EscalatedShapes.WIDE_WALKWAY_SIDE_RIGHT.get(facing);
    }
}

