/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.logistics.repackager;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.packager.repackager.RepackagerBlockEntity;
import java.util.List;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.HolderLookup;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import ru.zznty.create_factory_logistics.logistics.composite.CompositePackageItem;
import ru.zznty.create_factory_logistics.logistics.repackager.FactoryRepackagerHelper;

public class CompositeRepackagerHelper
extends FactoryRepackagerHelper {
    public CompositeRepackagerHelper(RepackagerBlockEntity blockEntity) {
        super(blockEntity);
    }

    @Override
    public List<BigItemStack> repack(int orderId, RandomSource r) {
        List<BigItemStack> exportingPackages = super.repack(orderId, r);
        if (exportingPackages.isEmpty()) {
            return exportingPackages;
        }
        UnmodifiableIterator partitioned = Iterators.partition(((List)this.collectedPackages.get(orderId)).stream().filter(box -> box.getItem().getClass() != PackageItem.class).iterator(), (int)Iterate.horizontalDirections.length);
        for (int i = 0; partitioned.hasNext() && i < exportingPackages.size(); ++i) {
            exportingPackages.set(i, new BigItemStack(CompositePackageItem.of((HolderLookup.Provider)this.blockEntity.getLevel().registryAccess(), exportingPackages.get((int)i).stack, ((List)partitioned.next()).stream().toList())));
        }
        if (partitioned.hasNext()) {
            partitioned.forEachRemaining(list -> {
                for (ItemStack box : list) {
                    exportingPackages.add(new BigItemStack(box));
                }
            });
        }
        return exportingPackages;
    }
}

