/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.logistics.panel.request;

import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.stockTicker.StockTickerBlockEntity;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.net.base.BasePacketPayload;
import net.createmod.catnip.net.base.ClientboundPacketPayload;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import ru.zznty.create_factory_abstractions.api.generic.stack.GenericStack;
import ru.zznty.create_factory_abstractions.generic.stack.GenericStackSerializer;
import ru.zznty.create_factory_abstractions.generic.support.BigGenericStack;
import ru.zznty.create_factory_logistics.FactoryPackets;

public record LogisticalStockResponsePacket(boolean lastPacket, BlockPos pos, List<BigItemStack> stacks) implements ClientboundPacketPayload
{
    @OnlyIn(value=Dist.CLIENT)
    public void handle(LocalPlayer player) {
        BlockEntity blockEntity = Minecraft.getInstance().level.getBlockEntity(this.pos);
        if (blockEntity instanceof StockTickerBlockEntity) {
            StockTickerBlockEntity stbe = (StockTickerBlockEntity)blockEntity;
            stbe.receiveStockPacket(this.stacks, this.lastPacket);
        }
    }

    public BasePacketPayload.PacketTypeProvider getTypeProvider() {
        return FactoryPackets.LOGISTICAL_STOCK_RESPONSE;
    }

    public static void write(RegistryFriendlyByteBuf buf, LogisticalStockResponsePacket packet) {
        buf.writeBoolean(packet.lastPacket);
        buf.writeBlockPos(packet.pos);
        buf.writeVarInt(packet.stacks.size());
        for (BigItemStack stack : packet.stacks) {
            GenericStackSerializer.write((GenericStack)BigGenericStack.of((BigItemStack)stack).get(), (RegistryFriendlyByteBuf)buf);
        }
    }

    public static LogisticalStockResponsePacket read(RegistryFriendlyByteBuf buf) {
        boolean lastPacket = buf.readBoolean();
        BlockPos pos = buf.readBlockPos();
        int count = buf.readVarInt();
        ArrayList<BigItemStack> stacks = new ArrayList<BigItemStack>(count);
        for (int i = 0; i < count; ++i) {
            stacks.add(BigGenericStack.of((GenericStack)GenericStackSerializer.read((RegistryFriendlyByteBuf)buf)).asStack());
        }
        return new LogisticalStockResponsePacket(lastPacket, pos, stacks);
    }
}

