/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.logistics.jar;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.fluids.transfer.GenericItemEmptying;
import com.simibubi.create.content.logistics.box.PackageEntity;
import com.simibubi.create.content.logistics.chute.ChuteBlock;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.data.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import ru.zznty.create_factory_logistics.FactoryEntities;
import ru.zznty.create_factory_logistics.logistics.jar.unpack.JarUnpackingHandler;
import ru.zznty.create_factory_logistics.mixin.accessor.PackageEntityAccessor;

public class JarPackageEntity
extends PackageEntity
implements IHaveGoggleInformation {
    public LerpedFloat fluidLevel = LerpedFloat.linear();

    public JarPackageEntity(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public JarPackageEntity(Level worldIn, double x, double y, double z) {
        this((EntityType)FactoryEntities.JAR.get(), worldIn);
        this.setPos(x, y, z);
        this.refreshDimensions();
    }

    public void tick() {
        super.tick();
        this.fluidLevel.tickChaser();
    }

    public void setBox(ItemStack box) {
        super.setBox(box);
        IFluidHandlerItem capability = (IFluidHandlerItem)box.getCapability(Capabilities.FluidHandler.ITEM);
        if (capability != null) {
            this.fluidLevel.chase((double)capability.getFluidInTank(0).getAmount(), 0.5, LerpedFloat.Chaser.EXP);
        }
    }

    protected void onInsideBlock(BlockState state) {
    }

    protected void dropAllDeathLoot(ServerLevel level, DamageSource pDamageSource) {
        Pair pair = GenericItemEmptying.emptyItem((Level)level, (ItemStack)this.box, (boolean)true);
        if (((FluidStack)pair.getFirst()).isEmpty()) {
            return;
        }
        JarUnpackingHandler handler = (JarUnpackingHandler)JarUnpackingHandler.REGISTRY.get((Object)((FluidStack)pair.getFirst()).getFluid());
        if (handler == null) {
            handler = JarUnpackingHandler.DEFAULT;
        }
        Player player = null;
        Entity entity = pDamageSource.getEntity();
        if (entity instanceof Player) {
            Player entity2;
            player = entity2 = (Player)entity;
        }
        handler.unpack(level, this.getOnPos(), (FluidStack)pair.getFirst(), player);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        Optional fluidHandler = FluidUtil.getFluidHandler((ItemStack)this.box);
        if (fluidHandler.isEmpty()) {
            return false;
        }
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, (IFluidHandler)fluidHandler.get());
    }

    public static JarPackageEntity fromDroppedItem(Level world, Entity originalEntity, ItemStack itemstack) {
        JarPackageEntity jarEntity = (JarPackageEntity)((EntityType)FactoryEntities.JAR.get()).create(world);
        Vec3 position = originalEntity.position();
        jarEntity.setPos(position);
        jarEntity.setBox(itemstack);
        jarEntity.setDeltaMovement(originalEntity.getDeltaMovement().scale(1.5));
        PackageEntityAccessor accessor = (PackageEntityAccessor)((Object)jarEntity);
        accessor.setOriginalEntity(originalEntity);
        if (world != null && !world.isClientSide && ChuteBlock.isChute((BlockState)world.getBlockState(BlockPos.containing((double)position.x, (double)(position.y + 0.5), (double)position.z)))) {
            jarEntity.setYRot((int)jarEntity.getYRot() / 90 * 90);
        }
        return jarEntity;
    }

    public static EntityType.Builder<?> build(EntityType.Builder<?> builder) {
        EntityType.Builder<?> boxBuilder = builder;
        return boxBuilder.sized(1.0f, 1.0f);
    }
}

