/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.foundation.copycat.multistate;

import com.copycatsplus.copycats.Copycats;
import com.copycatsplus.copycats.foundation.copycat.ICopycatBlockEntity;
import com.copycatsplus.copycats.foundation.copycat.multistate.IMultiStateCopycatBlockEntity;
import com.copycatsplus.copycats.foundation.copycat.multistate.MaterialItemStorage;
import com.copycatsplus.copycats.foundation.copycat.multistate.MultiStateCopycatBlock;
import com.copycatsplus.copycats.utility.BlockEntityUtils;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MultiStateCopycatBlockEntity
extends SmartBlockEntity
implements IMultiStateCopycatBlockEntity {
    private MaterialItemStorage materialItemStorage;

    public MultiStateCopycatBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.init();
    }

    @Override
    public MaterialItemStorage getMaterialItemStorage() {
        return this.materialItemStorage;
    }

    @Override
    public void setMaterialItemStorageInternal(MaterialItemStorage storage) {
        this.materialItemStorage = storage;
    }

    @Override
    public void onLoad() {
        super.onLoad();
        IMultiStateCopycatBlockEntity.super.onLoad();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    @Override
    public ItemRequirement getRequiredItems(BlockState state) {
        return IMultiStateCopycatBlockEntity.super.getRequiredItems(state);
    }

    public void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        IMultiStateCopycatBlockEntity.read(this, tag, registries, clientPacket);
    }

    public void writeSafe(CompoundTag tag, HolderLookup.Provider registries) {
        super.writeSafe(tag, registries);
        IMultiStateCopycatBlockEntity.writeSafe(this, tag, registries);
    }

    public void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(tag, registries, clientPacket);
        IMultiStateCopycatBlockEntity.write(this, tag, registries, clientPacket);
    }

    public void migrateData(ICopycatBlockEntity copycatBlockEntity) {
        Block block = this.getBlockState().getBlock();
        if (block instanceof MultiStateCopycatBlock) {
            MultiStateCopycatBlock mscb = (MultiStateCopycatBlock)block;
            ResourceLocation blockId = copycatBlockEntity.getBlockState().getBlock().builtInRegistryHolder().key().location();
            Copycats.LOGGER.debug("Converting block({}) at @{} to a multistate copycat", (Object)blockId.toString(), (Object)copycatBlockEntity.getBlockPos().toShortString());
            String firstProperty = this.getMaterialItemStorage().getAllProperties().stream().filter(prop -> mscb.partExists(this.getBlockState(), (String)prop)).findFirst().orElse(null);
            if (firstProperty == null) {
                Copycats.LOGGER.error("Failed to convert block({}) at @{} to a multistate copycat: no valid properties found", (Object)blockId.toString(), (Object)copycatBlockEntity.getBlockPos().toShortString());
                BlockEntityUtils.redraw((BlockEntity)this);
                return;
            }
            MaterialItemStorage.MaterialItem materialItem = this.materialItemStorage.getMaterialItem(firstProperty);
            materialItem.setMaterial(copycatBlockEntity.getMaterial());
            materialItem.setConsumedItem(copycatBlockEntity.getConsumedItem());
            for (String property : mscb.storageProperties()) {
                if (!mscb.partExists(this.getBlockState(), property) || this.getMaterialItemStorage().hasCustomMaterial(property)) continue;
                MaterialItemStorage.MaterialItem store = this.materialItemStorage.getMaterialItem(property);
                store.setMaterial(copycatBlockEntity.getMaterial());
                store.setConsumedItem(ItemStack.EMPTY);
            }
            BlockEntityUtils.redraw((BlockEntity)this);
        }
    }
}

