/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.fluidvessel;

import com.hlysine.create_connected.config.CServer;
import com.hlysine.create_connected.content.fluidvessel.CreativeFluidVesselBlockEntity;
import com.hlysine.create_connected.content.fluidvessel.FluidVesselBlock;
import com.hlysine.create_connected.content.fluidvessel.FluidVesselBlockEntity;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.api.boiler.BoilerHeater;
import com.simibubi.create.api.stress.BlockStressValues;
import com.simibubi.create.content.decoration.steamWhistle.WhistleBlock;
import com.simibubi.create.content.decoration.steamWhistle.WhistleBlockEntity;
import com.simibubi.create.content.fluids.tank.BoilerData;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.content.fluids.tank.SoundPool;
import com.simibubi.create.content.kinetics.steamEngine.SteamEngineBlock;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import joptsimple.internal.Strings;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.data.Iterate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class BoilerData
extends com.simibubi.create.content.fluids.tank.BoilerData {
    static final int SAMPLE_RATE = 5;
    private static final int waterSupplyPerLevel = 10;
    private static final float passiveEngineEfficiency = 0.125f;
    int gatheredSupply;
    float[] supplyOverTime = new float[10];
    int ticksUntilNextSample;
    int currentIndex;
    int configLevelCap = 18;
    private int maxHeatForSize = 0;
    private int maxHeatForWater = 0;
    private int minValue = 0;
    private int maxValue = 0;
    private final SoundPool.Sound sound = (level, pos) -> {
        float volume = 3.0f / (float)Math.max(2, this.attachedEngines / 6);
        float pitch = 1.18f - level.random.nextFloat() * 0.25f;
        level.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.CANDLE_EXTINGUISH, SoundSource.BLOCKS, volume, pitch, false);
        AllSoundEvents.STEAM.playAt(level, pos, volume / 16.0f, 0.8f, false);
    };
    private final EnumMap<Direction, SoundPool> pools = new EnumMap(Direction.class);

    public void tick(FluidTankBlockEntity controller) {
        if (!this.isActive()) {
            return;
        }
        this.configLevelCap = CServer.VesselMaxLevel.get();
        Level level = controller.getLevel();
        if (level.isClientSide) {
            this.pools.values().forEach(p -> p.play(level));
            this.gauge.tickChaser();
            float current = this.gauge.getValue(1.0f);
            if (current > 1.0f && level.random.nextFloat() < 0.5f) {
                this.gauge.setValueNoUpdate((double)(current + Math.min(-(current - 1.0f) * level.random.nextFloat(), 0.0f)));
            }
            return;
        }
        if (this.needsHeatLevelUpdate && this.updateTemperature(controller)) {
            controller.notifyUpdate();
        }
        --this.ticksUntilNextSample;
        if (this.ticksUntilNextSample > 0) {
            return;
        }
        int capacity = controller.getTankInventory().getCapacity();
        if (capacity == 0) {
            return;
        }
        this.ticksUntilNextSample = 5;
        this.supplyOverTime[this.currentIndex] = (float)this.gatheredSupply / 5.0f;
        this.waterSupply = Math.max(this.waterSupply, this.supplyOverTime[this.currentIndex]);
        this.currentIndex = (this.currentIndex + 1) % this.supplyOverTime.length;
        this.gatheredSupply = 0;
        if (this.currentIndex == 0) {
            this.waterSupply = 0.0f;
            for (float i : this.supplyOverTime) {
                this.waterSupply = Math.max(i, this.waterSupply);
            }
        }
        if (controller instanceof CreativeFluidVesselBlockEntity) {
            this.waterSupply = 200.0f;
        }
        if (this.getActualHeat(controller.getTotalTankSize()) == 18) {
            controller.award(AllAdvancements.STEAM_ENGINE_MAXED);
        }
        controller.notifyUpdate();
    }

    public void updateOcclusion(FluidTankBlockEntity base) {
        if (!(base instanceof FluidVesselBlockEntity)) {
            super.updateOcclusion(base);
            return;
        }
        FluidVesselBlockEntity controller = (FluidVesselBlockEntity)base;
        if (!controller.getLevel().isClientSide) {
            return;
        }
        if (this.attachedEngines + this.attachedWhistles == 0) {
            return;
        }
        for (Direction d : Iterate.horizontalDirections) {
            boolean alongLength = d.getAxis() == controller.getAxis();
            int size = alongLength ? controller.getHeight() : controller.getWidth();
            AABB aabb = new AABB(controller.getBlockPos()).move((double)((float)size / 2.0f - 0.5f), 0.0, (double)((float)size / 2.0f - 0.5f)).deflate(0.625);
            aabb = aabb.move((double)((float)d.getStepX() * ((float)size / 2.0f + 0.25f)), 0.0, (double)((float)d.getStepZ() * ((float)size / 2.0f + 0.25f)));
            aabb = aabb.inflate((double)((float)Math.abs(d.getStepZ()) / 2.0f), 0.25, (double)((float)Math.abs(d.getStepX()) / 2.0f));
            this.occludedDirections[d.get2DDataValue()] = !controller.getLevel().noCollision(aabb);
        }
    }

    public int getMaxHeatLevelForWaterSupply() {
        return Math.min(18, Mth.ceil((float)this.waterSupply) / 10);
    }

    public boolean isPassive() {
        return this.passiveHeat && this.maxHeatForSize > 0 && this.maxHeatForWater > 0;
    }

    public boolean isPassive(int boilerSize) {
        this.calcMinMaxForSize(boilerSize);
        return this.isPassive();
    }

    public float getEngineEfficiency(int boilerSize) {
        if (this.isPassive(boilerSize)) {
            return 0.125f / (float)this.attachedEngines * CServer.VesselBoilerStressMultiplier.get().floatValue();
        }
        if (this.activeHeat == 0) {
            return 0.0f;
        }
        int actualHeat = this.getActualHeat(boilerSize);
        return (this.attachedEngines <= actualHeat ? 1.0f : (float)actualHeat / (float)this.attachedEngines) * CServer.VesselBoilerStressMultiplier.get().floatValue();
    }

    private int getActualHeat(int boilerSize) {
        int forBoilerSize = this.getMaxHeatLevelForBoilerSize(boilerSize);
        int forWaterSupply = this.getMaxHeatLevelForWaterSupply();
        int actualHeat = Math.min(Math.min(this.activeHeat, Math.min(forWaterSupply, forBoilerSize)), this.configLevelCap);
        return actualHeat;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking, int boilerSize) {
        if (!this.isActive()) {
            return false;
        }
        this.calcMinMaxForSize(boilerSize);
        if (this.configLevelCap < 18) {
            CreateLang.translate((String)"boiler.status", (Object[])new Object[]{this.getHeatLevelTextComponent().withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)(" / " + this.configLevelCap)).withStyle(ChatFormatting.GRAY))}).forGoggles(tooltip);
        } else {
            CreateLang.translate((String)"boiler.status", (Object[])new Object[]{this.getHeatLevelTextComponent().withStyle(ChatFormatting.GREEN)}).forGoggles(tooltip);
        }
        CreateLang.builder().add(this.getSizeComponent(true, false, new ChatFormatting[0])).forGoggles(tooltip, 1);
        CreateLang.builder().add(this.getWaterComponent(true, false, new ChatFormatting[0])).forGoggles(tooltip, 1);
        CreateLang.builder().add(this.getHeatComponent(true, false, new ChatFormatting[0])).forGoggles(tooltip, 1);
        if (this.attachedEngines == 0) {
            return true;
        }
        int boilerLevel = Math.min(this.activeHeat, Math.min(this.maxHeatForWater, this.maxHeatForSize));
        double totalSU = (double)(this.getEngineEfficiency(boilerSize) * 16.0f * (float)Math.max(boilerLevel, this.attachedEngines)) * BlockStressValues.getCapacity((Block)((Block)AllBlocks.STEAM_ENGINE.get()));
        tooltip.add(CommonComponents.EMPTY);
        if (this.attachedEngines > 0 && this.maxHeatForSize > 0 && this.maxHeatForWater == 0 && (this.passiveHeat ? 1 : this.activeHeat) > 0) {
            CreateLang.translate((String)"boiler.water_input_rate", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
            CreateLang.number((double)this.waterSupply).style(ChatFormatting.BLUE).add(CreateLang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0])).add(CreateLang.text((String)" / ").style(ChatFormatting.GRAY)).add(CreateLang.translate((String)"boiler.per_tick", (Object[])new Object[]{CreateLang.number((double)10.0).add(CreateLang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]))}).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
            return true;
        }
        CreateLang.translate((String)"tooltip.capacityProvided", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        CreateLang.number((double)totalSU).translate("generic.unit.stress", new Object[0]).style(ChatFormatting.AQUA).space().add((this.attachedEngines == 1 ? CreateLang.translate((String)"boiler.via_one_engine", (Object[])new Object[0]) : CreateLang.translate((String)"boiler.via_engines", (Object[])new Object[]{this.attachedEngines})).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        return true;
    }

    public void calcMinMaxForSize(int boilerSize) {
        this.maxHeatForSize = this.getMaxHeatLevelForBoilerSize(boilerSize);
        this.maxHeatForWater = this.getMaxHeatLevelForWaterSupply();
        this.minValue = Math.min(this.configLevelCap, Math.min(this.passiveHeat ? 1 : this.activeHeat, Math.min(this.maxHeatForWater, this.maxHeatForSize)));
        this.maxValue = Math.max(this.passiveHeat ? 1 : this.activeHeat, Math.max(this.maxHeatForWater, this.maxHeatForSize));
    }

    @NotNull
    public MutableComponent getHeatLevelTextComponent() {
        int boilerLevel = Math.min(Math.min(this.activeHeat, Math.min(this.maxHeatForWater, this.maxHeatForSize)), this.configLevelCap);
        return this.isPassive() ? CreateLang.translateDirect((String)"boiler.passive", (Object[])new Object[0]) : (boilerLevel == 0 ? CreateLang.translateDirect((String)"boiler.idle", (Object[])new Object[0]) : (boilerLevel == 18 ? CreateLang.translateDirect((String)"boiler.max_lvl", (Object[])new Object[0]) : CreateLang.translateDirect((String)"boiler.lvl", (Object[])new Object[]{String.valueOf(boilerLevel)})));
    }

    public MutableComponent getSizeComponent(boolean forGoggles, boolean useBlocksAsBars, ChatFormatting ... styles) {
        return this.componentHelper("size", this.maxHeatForSize, forGoggles, useBlocksAsBars, styles);
    }

    public MutableComponent getWaterComponent(boolean forGoggles, boolean useBlocksAsBars, ChatFormatting ... styles) {
        return this.componentHelper("water", this.maxHeatForWater, forGoggles, useBlocksAsBars, styles);
    }

    public MutableComponent getHeatComponent(boolean forGoggles, boolean useBlocksAsBars, ChatFormatting ... styles) {
        return this.componentHelper("heat", this.passiveHeat ? 1 : this.activeHeat, forGoggles, useBlocksAsBars, styles);
    }

    private MutableComponent componentHelper(String label, int level, boolean forGoggles, boolean useBlocksAsBars, ChatFormatting ... styles) {
        MutableComponent base;
        MutableComponent mutableComponent = base = useBlocksAsBars ? this.blockComponent(level) : this.barComponent(level);
        if (!forGoggles) {
            return base;
        }
        ChatFormatting style1 = styles.length >= 1 ? styles[0] : ChatFormatting.GRAY;
        ChatFormatting style2 = styles.length >= 2 ? styles[1] : ChatFormatting.DARK_GRAY;
        return CreateLang.translateDirect((String)("boiler." + label), (Object[])new Object[0]).withStyle(style1).append((Component)CreateLang.translateDirect((String)("boiler." + label + "_dots"), (Object[])new Object[0]).withStyle(style2)).append((Component)base);
    }

    private MutableComponent blockComponent(int level) {
        return Component.literal((String)("\u2588".repeat(this.minValue) + "\u2592".repeat(level - this.minValue) + "\u2591".repeat(this.maxValue - level)));
    }

    private MutableComponent barComponent(int level) {
        return Component.empty().append((Component)this.bars(Math.max(0, this.minValue - 1), ChatFormatting.DARK_GREEN)).append((Component)this.bars(this.minValue > 0 ? 1 : 0, ChatFormatting.GREEN)).append((Component)this.bars(Math.max(0, level - this.minValue), ChatFormatting.DARK_GREEN)).append((Component)this.bars(Math.max(0, this.maxValue - level), ChatFormatting.DARK_RED)).append((Component)this.bars(Math.max(0, Math.min(18 - this.maxValue, (this.maxValue / 5 + 1) * 5 - this.maxValue)), ChatFormatting.DARK_GRAY));
    }

    private MutableComponent bars(int level, ChatFormatting format) {
        return Component.literal((String)Strings.repeat((char)'|', (int)level)).withStyle(format);
    }

    public boolean evaluate(FluidTankBlockEntity base) {
        if (!(base instanceof FluidVesselBlockEntity)) {
            return super.evaluate(base);
        }
        FluidVesselBlockEntity controller = (FluidVesselBlockEntity)base;
        BlockPos controllerPos = controller.getBlockPos();
        Level level = controller.getLevel();
        this.configLevelCap = CServer.VesselMaxLevel.get();
        int prevEngines = this.attachedEngines;
        int prevWhistles = this.attachedWhistles;
        this.attachedEngines = 0;
        this.attachedWhistles = 0;
        Direction.Axis axis = controller.getAxis();
        for (int yOffset = 0; yOffset < controller.getWidth(); ++yOffset) {
            for (int lengthOffset = 0; lengthOffset < controller.getHeight(); ++lengthOffset) {
                for (int widthOffset = 0; widthOffset < controller.getWidth(); ++widthOffset) {
                    BlockPos pos = controllerPos.offset(axis == Direction.Axis.X ? lengthOffset : widthOffset, yOffset, axis == Direction.Axis.Z ? lengthOffset : widthOffset);
                    BlockState blockState = level.getBlockState(pos);
                    if (!FluidVesselBlock.isVessel(blockState)) continue;
                    for (Direction d : Iterate.directions) {
                        BlockPos attachedPos = pos.relative(d);
                        BlockState attachedState = level.getBlockState(attachedPos);
                        if (AllBlocks.STEAM_ENGINE.has(attachedState) && SteamEngineBlock.getFacing((BlockState)attachedState) == d) {
                            ++this.attachedEngines;
                        }
                        if (!AllBlocks.STEAM_WHISTLE.has(attachedState) || WhistleBlock.getAttachedDirection((BlockState)attachedState).getOpposite() != d) continue;
                        ++this.attachedWhistles;
                    }
                }
            }
        }
        this.needsHeatLevelUpdate = true;
        return prevEngines != this.attachedEngines || prevWhistles != this.attachedWhistles;
    }

    public void checkPipeOrganAdvancement(FluidTankBlockEntity base) {
        if (!(base instanceof FluidVesselBlockEntity)) {
            super.checkPipeOrganAdvancement(base);
            return;
        }
        FluidVesselBlockEntity controller = (FluidVesselBlockEntity)base;
        if (!((AdvancementBehaviour)controller.getBehaviour(AdvancementBehaviour.TYPE)).isOwnerPresent()) {
            return;
        }
        BlockPos controllerPos = controller.getBlockPos();
        Level level = controller.getLevel();
        HashSet<Integer> whistlePitches = new HashSet<Integer>();
        Direction.Axis axis = controller.getAxis();
        for (int yOffset = 0; yOffset < controller.getWidth(); ++yOffset) {
            for (int lengthOffset = 0; lengthOffset < controller.getHeight(); ++lengthOffset) {
                for (int widthOffset = 0; widthOffset < controller.getWidth(); ++widthOffset) {
                    BlockPos pos = controllerPos.offset(axis == Direction.Axis.X ? lengthOffset : widthOffset, yOffset, axis == Direction.Axis.Z ? lengthOffset : widthOffset);
                    BlockState blockState = level.getBlockState(pos);
                    if (!FluidVesselBlock.isVessel(blockState)) continue;
                    for (Direction d : Iterate.directions) {
                        BlockEntity blockEntity;
                        BlockPos attachedPos = pos.relative(d);
                        BlockState attachedState = level.getBlockState(attachedPos);
                        if (!AllBlocks.STEAM_WHISTLE.has(attachedState) || WhistleBlock.getAttachedDirection((BlockState)attachedState).getOpposite() != d || !((blockEntity = level.getBlockEntity(attachedPos)) instanceof WhistleBlockEntity)) continue;
                        WhistleBlockEntity wbe = (WhistleBlockEntity)blockEntity;
                        whistlePitches.add(wbe.getPitchId());
                    }
                }
            }
        }
        if (whistlePitches.size() >= 12) {
            controller.award(AllAdvancements.PIPE_ORGAN);
        }
    }

    public boolean updateTemperature(FluidTankBlockEntity base) {
        if (!(base instanceof FluidVesselBlockEntity)) {
            return super.updateTemperature(base);
        }
        FluidVesselBlockEntity controller = (FluidVesselBlockEntity)base;
        BlockPos controllerPos = controller.getBlockPos();
        Level level = controller.getLevel();
        this.needsHeatLevelUpdate = false;
        boolean prevPassive = this.passiveHeat;
        int prevActive = this.activeHeat;
        this.passiveHeat = false;
        this.activeHeat = 0;
        Direction.Axis axis = controller.getAxis();
        for (int lengthOffset = 0; lengthOffset < controller.getHeight(); ++lengthOffset) {
            for (int widthOffset = 0; widthOffset < controller.getWidth(); ++widthOffset) {
                BlockState blockState;
                BlockPos pos = controllerPos.offset(axis == Direction.Axis.X ? lengthOffset : widthOffset, -1, axis == Direction.Axis.Z ? lengthOffset : widthOffset);
                float heat = BoilerHeater.findHeat((Level)level, (BlockPos)pos, (BlockState)(blockState = level.getBlockState(pos)));
                if (heat == 0.0f) {
                    this.passiveHeat = true;
                    continue;
                }
                if (!(heat > 0.0f)) continue;
                this.activeHeat = (int)((float)this.activeHeat + heat);
            }
        }
        this.activeHeat = Math.max(0, Math.min(18, (int)Math.floor((float)this.activeHeat * CServer.VesselHeatMultiplier.get().floatValue())));
        this.passiveHeat &= this.activeHeat == 0;
        return prevActive != this.activeHeat || prevPassive != this.passiveHeat;
    }

    public void clear() {
        this.waterSupply = 0.0f;
        this.activeHeat = 0;
        this.passiveHeat = false;
        this.attachedEngines = 0;
        Arrays.fill(this.supplyOverTime, 0.0f);
    }

    public CompoundTag write() {
        CompoundTag nbt = new CompoundTag();
        nbt.putFloat("Supply", this.waterSupply);
        nbt.putInt("ActiveHeat", this.activeHeat);
        nbt.putBoolean("PassiveHeat", this.passiveHeat);
        nbt.putInt("Engines", this.attachedEngines);
        nbt.putInt("Whistles", this.attachedWhistles);
        nbt.putBoolean("Update", this.needsHeatLevelUpdate);
        return nbt;
    }

    public void read(CompoundTag nbt, int boilerSize) {
        this.waterSupply = nbt.getFloat("Supply");
        this.activeHeat = nbt.getInt("ActiveHeat");
        this.passiveHeat = nbt.getBoolean("PassiveHeat");
        this.attachedEngines = nbt.getInt("Engines");
        this.attachedWhistles = nbt.getInt("Whistles");
        this.needsHeatLevelUpdate = nbt.getBoolean("Update");
        Arrays.fill(this.supplyOverTime, (float)((int)this.waterSupply));
        int forBoilerSize = this.getMaxHeatLevelForBoilerSize(boilerSize);
        int forWaterSupply = this.getMaxHeatLevelForWaterSupply();
        int actualHeat = Math.min(this.activeHeat, Math.min(forWaterSupply, forBoilerSize));
        float target = this.isPassive(boilerSize) ? 0.125f : (forBoilerSize == 0 ? 0.0f : (float)actualHeat / ((float)forBoilerSize * 1.0f));
        this.gauge.chase((double)target, 0.125, LerpedFloat.Chaser.EXP);
    }

    public BoilerFluidHandler createHandler() {
        return new BoilerFluidHandler();
    }

    public class BoilerFluidHandler
    extends BoilerData.BoilerFluidHandler {
        public BoilerFluidHandler() {
            super((com.simibubi.create.content.fluids.tank.BoilerData)BoilerData.this);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (!this.isFluidValid(0, resource)) {
                return 0;
            }
            int amount = resource.getAmount();
            if (action.execute()) {
                BoilerData.this.gatheredSupply += amount;
            }
            return amount;
        }
    }
}

