/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.contraption.jukebox;

import com.hlysine.create_connected.content.contraption.jukebox.PlayContraptionJukeboxPacket;
import com.simibubi.create.api.behaviour.interaction.MovingInteractionBehaviour;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.createmod.catnip.levelWrappers.WrappedLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.JukeboxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class JukeboxInteractionBehaviour
extends MovingInteractionBehaviour {
    public boolean handlePlayerInteraction(Player player, InteractionHand activeHand, BlockPos contraptionPos, AbstractContraptionEntity contraptionEntity) {
        if (player.level().isClientSide()) {
            return true;
        }
        Contraption contraption = contraptionEntity.getContraption();
        StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(contraptionPos);
        BlockState currentState = info.state();
        if (((Boolean)currentState.getValue((Property)BlockStateProperties.HAS_RECORD)).booleanValue()) {
            this.withTempBlockEntity(contraption, contraptionPos, currentState, JukeboxBlockEntity::popOutTheItem, false);
        } else {
            ItemStack item = player.getItemInHand(activeHand);
            if (item.getItem().components().has(DataComponents.JUKEBOX_PLAYABLE)) {
                this.withTempBlockEntity(contraption, contraptionPos, currentState, be -> {
                    be.setTheItem(item.copy());
                    be.getLevel().gameEvent((Holder)GameEvent.BLOCK_CHANGE, be.getBlockPos(), GameEvent.Context.of((Entity)player, (BlockState)currentState));
                    if (!player.isCreative()) {
                        item.shrink(1);
                    }
                    player.awardStat(Stats.PLAY_RECORD);
                }, false);
            }
        }
        return true;
    }

    public void withTempBlockEntity(Contraption contraption, final BlockPos contraptionPos, BlockState currentState, Consumer<JukeboxBlockEntity> action, final boolean silent) {
        final AtomicReference<BlockState> state = new AtomicReference<BlockState>(currentState);
        final AbstractContraptionEntity contraptionEntity = contraption.entity;
        final BlockPos realPos = BlockPos.containing((Position)contraptionEntity.toGlobalVector(Vec3.atCenterOf((Vec3i)contraptionPos), 1.0f));
        JukeboxBlockEntity be = new JukeboxBlockEntity(realPos, currentState);
        be.loadWithComponents(((StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(contraptionPos)).nbt(), (HolderLookup.Provider)contraptionEntity.level().registryAccess());
        be.setLevel((Level)new WrappedLevel(this, contraptionEntity.level()){

            public boolean setBlock(BlockPos pos, BlockState newState, int flags) {
                if (pos.equals((Object)realPos)) {
                    state.set(newState);
                    return true;
                }
                return false;
            }

            public BlockState getBlockState(@Nullable BlockPos pos) {
                if (pos.equals((Object)realPos)) {
                    return (BlockState)state.get();
                }
                return super.getBlockState(pos);
            }

            public void levelEvent(@Nullable Player player, int type, BlockPos pos, int data) {
                if (type == 1010 || type == 1011) {
                    PacketDistributor.sendToPlayersInDimension((ServerLevel)((ServerLevel)contraptionEntity.level()), (CustomPacketPayload)new PlayContraptionJukeboxPacket(this.dimension().location(), contraptionEntity.getId(), contraptionPos, pos, data, type == 1010, silent), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        });
        action.accept(be);
        this.setContraptionBlockData(contraptionEntity, contraptionPos, new StructureTemplate.StructureBlockInfo(contraptionPos, state.get(), be.saveWithoutMetadata((HolderLookup.Provider)contraptionEntity.level().registryAccess())));
    }
}

