/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easymagic.mixin;

import fuzs.easymagic.EasyMagic;
import fuzs.easymagic.config.ServerConfig;
import fuzs.easymagic.util.ChiseledBookshelfHelper;
import fuzs.puzzleslib.api.core.v1.CommonAbstractions;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.EnchantingTableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.phys.shapes.Shapes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EnchantingTableBlock.class})
abstract class EnchantingTableBlockMixin
extends BaseEntityBlock {
    protected EnchantingTableBlockMixin(BlockBehaviour.Properties builder) {
        super(builder);
    }

    @Inject(method={"isValidBookShelf"}, at={@At(value="HEAD")}, cancellable=true)
    private static void isValidBookShelf(Level level, BlockPos pos, BlockPos offset, CallbackInfoReturnable<Boolean> callback) {
        if (CommonAbstractions.INSTANCE.getEnchantPowerBonus(level.getBlockState(pos.offset((Vec3i)offset)), level, pos.offset((Vec3i)offset)) == 0.0f && ChiseledBookshelfHelper.findValidBooks(level, pos, offset) == 0) {
            callback.setReturnValue((Object)false);
            return;
        }
        BlockPos inBetweenPos = pos.offset(offset.getX() / 2, offset.getY(), offset.getZ() / 2);
        boolean isEmpty = ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).lenientBookshelves ? level.getBlockState(inBetweenPos).getCollisionShape((BlockGetter)level, inBetweenPos) != Shapes.block() : level.isEmptyBlock(inBetweenPos);
        callback.setReturnValue((Object)isEmpty);
    }
}

