/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easymagic.client.gui.components;

import fuzs.easymagic.EasyMagic;
import fuzs.easymagic.config.ClientConfig;
import fuzs.easymagic.config.ServerConfig;
import fuzs.easymagic.world.inventory.ModEnchantmentMenu;
import fuzs.puzzleslib.api.client.gui.v2.components.SpritelessImageButton;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.texture.Tickable;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FastColor;

public class RerollButton
extends SpritelessImageButton
implements Tickable {
    public static final ResourceLocation ENCHANTING_TABLE_REROLL_LOCATION = EasyMagic.id("textures/gui/container/enchanting_table_reroll.png");
    private final int rerollExperiencePointsCost;
    private final int rerollCatalystCost;
    private final ModEnchantmentMenu menu;

    public RerollButton(int x, int y, Button.OnPress onPress, ModEnchantmentMenu menu) {
        super(x, y, 38, 27, 0, 0, ENCHANTING_TABLE_REROLL_LOCATION, onPress);
        this.rerollExperiencePointsCost = ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollExperiencePointsCost;
        this.rerollCatalystCost = ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollCatalystCost;
        this.setTextureLayout(LEGACY_TEXTURE_LAYOUT);
        this.menu = menu;
    }

    public void tick() {
        this.visible = this.menu.canEnchantItem();
        this.active = this.menu.canUseReroll(this.menu.player);
    }

    public void playDownSound(SoundManager soundManager) {
        soundManager.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.ENCHANTMENT_TABLE_USE, (float)1.0f));
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!((ClientConfig)EasyMagic.CONFIG.get(ClientConfig.class)).keepEnchantmentScreenBook()) {
            super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
            this.renderWidgetDecorations(guiGraphics);
        }
    }

    private void renderWidgetDecorations(GuiGraphics guiGraphics) {
        if (this.rerollExperiencePointsCost == 0 && this.rerollCatalystCost == 0) {
            guiGraphics.blit(ENCHANTING_TABLE_REROLL_LOCATION, this.getX() + 12, this.getY() + 6, 64.0f, !this.isActive() ? 0.0f : (this.isHoveredOrFocused() ? 30.0f : 15.0f), 15, 15, 256, 256);
        } else {
            guiGraphics.blit(ENCHANTING_TABLE_REROLL_LOCATION, this.getX() + 3, this.getY() + 6, 64.0f, !this.isActive() ? 0.0f : (this.isHoveredOrFocused() ? 30.0f : 15.0f), 15, 15, 256, 256);
            if (this.rerollExperiencePointsCost > 0 && this.rerollCatalystCost > 0) {
                this.renderCostOrb(guiGraphics, this.getX() + (this.rerollExperiencePointsCost > 9 ? 17 : 20), this.getY() + 13, 38, !this.isActive() ? 39 : 0, this.rerollExperiencePointsCost, !this.isActive() ? ChatFormatting.RED : ChatFormatting.GREEN);
                this.renderCostOrb(guiGraphics, this.getX() + (this.rerollCatalystCost > 9 ? 17 : 20), this.getY() + 1, 51, !this.isActive() ? 39 : 0, this.rerollCatalystCost, !this.isActive() ? ChatFormatting.RED : ChatFormatting.BLUE);
            } else if (this.rerollExperiencePointsCost > 0) {
                this.renderCostOrb(guiGraphics, this.getX() + (this.rerollExperiencePointsCost > 9 ? 17 : 20), this.getY() + 7, 38, !this.isActive() ? 39 : 0, this.rerollExperiencePointsCost, !this.isActive() ? ChatFormatting.RED : ChatFormatting.GREEN);
            } else if (this.rerollCatalystCost > 0) {
                this.renderCostOrb(guiGraphics, this.getX() + (this.rerollCatalystCost > 9 ? 17 : 20), this.getY() + 7, 51, !this.isActive() ? 39 : 0, this.rerollCatalystCost, !this.isActive() ? ChatFormatting.RED : ChatFormatting.BLUE);
            }
        }
    }

    private void renderCostOrb(GuiGraphics guiGraphics, int posX, int posY, int textureX, int textureY, int cost, ChatFormatting color) {
        guiGraphics.blit(ENCHANTING_TABLE_REROLL_LOCATION, posX, posY, (float)textureX, (float)(textureY + Math.min(2, cost / 5) * 13), 13, 13, 256, 256);
        Font font = Minecraft.getInstance().font;
        RerollButton.drawInBatch8xOutline(guiGraphics, font, (Component)Component.literal((String)String.valueOf(cost)), posX + 8, posY + 3, FastColor.ABGR32.opaque((int)color.getColor()), FastColor.ABGR32.opaque((int)0));
    }

    @Deprecated
    public static void drawInBatch8xOutline(GuiGraphics guiGraphics, Font font, Component component, int posX, int posY, int color, int backgroundColor) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (i == 0 && j == 0) continue;
                guiGraphics.drawString(font, component, posX + i, posY + j, backgroundColor, false);
            }
        }
        guiGraphics.drawString(font, component, posX, posY, color, false);
    }
}

