/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.util;

import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.api.part.RandomTickPart;
import codechicken.multipart.util.WorldTickScheduler;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

public class TickScheduler {
    private static final CrashLock LOCK = new CrashLock("Already initialized.");

    public static void init() {
        LOCK.lock();
        NeoForge.EVENT_BUS.addListener(EventPriority.HIGHEST, TickScheduler::onChunkLoad);
        NeoForge.EVENT_BUS.addListener(EventPriority.LOWEST, TickScheduler::onChunkUnload);
        NeoForge.EVENT_BUS.addListener(TickScheduler::onWorldTick);
    }

    private static void onChunkLoad(ChunkEvent.Load event) {
        ServerLevel level;
        LevelAccessor levelAccessor;
        block3: {
            block2: {
                levelAccessor = event.getLevel();
                if (!(levelAccessor instanceof ServerLevel)) break block2;
                level = (ServerLevel)levelAccessor;
                levelAccessor = event.getChunk();
                if (levelAccessor instanceof LevelChunk) break block3;
            }
            return;
        }
        LevelChunk chunk = (LevelChunk)levelAccessor;
        WorldTickScheduler scheduler = WorldTickScheduler.getInstance(level);
        scheduler.onChunkLoad(chunk);
    }

    private static void onChunkUnload(ChunkEvent.Unload event) {
        ServerLevel level;
        LevelAccessor levelAccessor;
        block3: {
            block2: {
                levelAccessor = event.getLevel();
                if (!(levelAccessor instanceof ServerLevel)) break block2;
                level = (ServerLevel)levelAccessor;
                levelAccessor = event.getChunk();
                if (levelAccessor instanceof LevelChunk) break block3;
            }
            return;
        }
        LevelChunk chunk = (LevelChunk)levelAccessor;
        WorldTickScheduler scheduler = WorldTickScheduler.getInstance(level);
        scheduler.onChunkUnload(chunk);
    }

    private static void onWorldTick(LevelTickEvent.Post event) {
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        WorldTickScheduler worldScheduler = WorldTickScheduler.getInstance(level2);
        worldScheduler.tick();
    }

    public static void scheduleTick(MultiPart part, int ticks) {
        ServerLevel level;
        ChunkAccess chunk;
        Level level2 = part.level();
        if (level2 instanceof ServerLevel && (chunk = (level = (ServerLevel)level2).getChunk(part.pos())) instanceof LevelChunk) {
            LevelChunk lc = (LevelChunk)chunk;
            WorldTickScheduler.ChunkScheduler chunkScheduler = WorldTickScheduler.getInstance(lc);
            chunkScheduler.addScheduledTick(part, ticks);
        }
    }

    public static void loadRandomTick(RandomTickPart part) {
        ServerLevel level;
        ChunkAccess chunk;
        Level level2 = part.level();
        if (level2 instanceof ServerLevel && (chunk = (level = (ServerLevel)level2).getChunk(part.pos())) instanceof LevelChunk) {
            TickScheduler.loadRandomTick(part, (LevelChunk)chunk);
        }
    }

    public static void loadRandomTick(RandomTickPart part, LevelChunk chunk) {
        if (chunk.getLevel() instanceof ServerLevel) {
            WorldTickScheduler.ChunkScheduler chunkScheduler = WorldTickScheduler.getInstance(chunk);
            chunkScheduler.loadRandomTick(part);
        }
    }
}

