/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.util;

import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.block.TileMultipart;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Contract;

public class MultipartPlaceContext
extends BlockPlaceContext {
    private final double hitDepth;
    private final BlockPos offsetPos;
    private boolean isOffset = false;

    public MultipartPlaceContext(UseOnContext context) {
        this(Objects.requireNonNull(context.getPlayer()), context.getHand(), context.getHitResult());
    }

    public MultipartPlaceContext(Player player, InteractionHand hand, BlockHitResult hit) {
        super(player, hand, player.getItemInHand(hand), hit);
        this.hitDepth = this.calcHitDepth(hit.getLocation(), hit.getBlockPos(), hit.getDirection());
        this.offsetPos = hit.getBlockPos().relative(hit.getDirection());
    }

    @Contract(value="-> this")
    public MultipartPlaceContext applyOffset() {
        this.isOffset = true;
        return this;
    }

    public double getHitDepth() {
        return this.hitDepth;
    }

    public boolean isOffset() {
        return this.isOffset;
    }

    public boolean canPlacePart(MultiPart part) {
        return TileMultipart.canPlacePart((UseOnContext)this, part);
    }

    public BlockPos getClickedPos() {
        return this.isOffset ? this.offsetPos : this.getHitResult().getBlockPos();
    }

    private double calcHitDepth(Vec3 clickLocation, BlockPos clickPos, Direction face) {
        Vector3 vHit = new Vector3(clickLocation).subtract((Vec3i)clickPos);
        int side = face.ordinal();
        return vHit.scalarProject(Rotation.axes[side]) + (double)(side % 2 ^ 1);
    }
}

