/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.minecraft;

import codechicken.lib.util.ArrayUtils;
import codechicken.multipart.api.MultipartType;
import codechicken.multipart.api.PartConverter;
import codechicken.multipart.api.SimpleMultipartType;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.minecraft.ButtonPart;
import codechicken.multipart.minecraft.LeverPart;
import codechicken.multipart.minecraft.McStatePart;
import codechicken.multipart.minecraft.RedstoneTorchPart;
import codechicken.multipart.minecraft.SoulTorchPart;
import codechicken.multipart.minecraft.TorchPart;
import codechicken.multipart.util.MultipartPlaceContext;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class MinecraftMultipartModContent {
    private static final DeferredRegister<MultipartType<?>> MULTIPART_TYPES = DeferredRegister.create(MultipartType.MULTIPART_TYPES, (String)"minecraft");
    private static final DeferredRegister<PartConverter> PART_CONVERTERS = DeferredRegister.create(PartConverter.PART_CONVERTERS, (String)"minecraft");
    public static final DeferredHolder<MultipartType<?>, MultipartType<TorchPart>> TORCH_PART = MULTIPART_TYPES.register("torch", () -> new SimpleMultipartType<TorchPart>(e -> new TorchPart()));
    public static final DeferredHolder<MultipartType<?>, MultipartType<SoulTorchPart>> SOUL_TORCH_PART = MULTIPART_TYPES.register("soul_torch", () -> new SimpleMultipartType<SoulTorchPart>(e -> new SoulTorchPart()));
    public static final DeferredHolder<MultipartType<?>, MultipartType<RedstoneTorchPart>> REDSTONE_TORCH_PART = MULTIPART_TYPES.register("redstone_torch", () -> new SimpleMultipartType<RedstoneTorchPart>(e -> new RedstoneTorchPart()));
    public static final DeferredHolder<MultipartType<?>, MultipartType<LeverPart>> LEVER_PART = MULTIPART_TYPES.register("lever", () -> new SimpleMultipartType<LeverPart>(e -> new LeverPart()));
    public static final DeferredHolder<MultipartType<?>, MultipartType<ButtonPart.StoneButtonPart>> STONE_BUTTON_PART = MULTIPART_TYPES.register("stone_button", () -> new SimpleMultipartType<ButtonPart.StoneButtonPart>(e -> new ButtonPart.StoneButtonPart()));
    public static final DeferredHolder<MultipartType<?>, MultipartType<ButtonPart.PolishedBlackstoneButtonPart>> POLISHED_BLACKSTONE_BUTTON_PART = MULTIPART_TYPES.register("polished_blackstone_button", () -> new SimpleMultipartType<ButtonPart.PolishedBlackstoneButtonPart>(e -> new ButtonPart.PolishedBlackstoneButtonPart()));
    public static final DeferredHolder<MultipartType<?>, MultipartType<ButtonPart.OakButtonPart>> OAK_BUTTON_PART = MULTIPART_TYPES.register("oak_button", () -> new SimpleMultipartType<ButtonPart.OakButtonPart>(e -> new ButtonPart.OakButtonPart()));
    public static final DeferredHolder<MultipartType<?>, MultipartType<ButtonPart.SpruceButtonPart>> SPRUCE_BUTTON_PART = MULTIPART_TYPES.register("spruce_button", () -> new SimpleMultipartType<ButtonPart.SpruceButtonPart>(e -> new ButtonPart.SpruceButtonPart()));
    public static final DeferredHolder<MultipartType<?>, MultipartType<ButtonPart.BirchButtonPart>> BIRCH_BUTTON_PART = MULTIPART_TYPES.register("birch_button", () -> new SimpleMultipartType<ButtonPart.BirchButtonPart>(e -> new ButtonPart.BirchButtonPart()));
    public static final DeferredHolder<MultipartType<?>, MultipartType<ButtonPart.JungleButtonPart>> JUNGLE_BUTTON_PART = MULTIPART_TYPES.register("jungle_button", () -> new SimpleMultipartType<ButtonPart.JungleButtonPart>(e -> new ButtonPart.JungleButtonPart()));
    public static final DeferredHolder<MultipartType<?>, MultipartType<ButtonPart.AcaciaButtonPart>> ACACIA_BUTTON_PART = MULTIPART_TYPES.register("acacia_button", () -> new SimpleMultipartType<ButtonPart.AcaciaButtonPart>(e -> new ButtonPart.AcaciaButtonPart()));
    public static final DeferredHolder<MultipartType<?>, MultipartType<ButtonPart.DarkOakButtonPart>> DARK_OAK_BUTTON_PART = MULTIPART_TYPES.register("dark_oak_button", () -> new SimpleMultipartType<ButtonPart.DarkOakButtonPart>(e -> new ButtonPart.DarkOakButtonPart()));
    public static final DeferredHolder<MultipartType<?>, MultipartType<ButtonPart.CrimsonButtonPart>> CRIMSON_BUTTON_PART = MULTIPART_TYPES.register("crimson_button", () -> new SimpleMultipartType<ButtonPart.CrimsonButtonPart>(e -> new ButtonPart.CrimsonButtonPart()));
    public static final DeferredHolder<MultipartType<?>, MultipartType<ButtonPart.WarpedButtonPart>> WARPED_BUTTON_PART = MULTIPART_TYPES.register("warped_button", () -> new SimpleMultipartType<ButtonPart.WarpedButtonPart>(e -> new ButtonPart.WarpedButtonPart()));
    private static final DeferredHolder<PartConverter, PartConverter> TORCH_CONVERTER = PART_CONVERTERS.register("torch", () -> new Converter<TorchPart>(TorchPart::new, TorchPart::new, Items.TORCH, Blocks.TORCH, Blocks.WALL_TORCH));
    private static final DeferredHolder<PartConverter, PartConverter> SOUL_TORCH_CONVERTER = PART_CONVERTERS.register("soul_torch", () -> new Converter<SoulTorchPart>(SoulTorchPart::new, SoulTorchPart::new, Items.SOUL_TORCH, Blocks.SOUL_TORCH, Blocks.SOUL_WALL_TORCH));
    private static final DeferredHolder<PartConverter, PartConverter> REDSTONE_TORCH_CONVERTER = PART_CONVERTERS.register("redstone_torch", () -> new Converter<RedstoneTorchPart>(RedstoneTorchPart::new, RedstoneTorchPart::new, Items.REDSTONE_TORCH, Blocks.REDSTONE_TORCH, Blocks.REDSTONE_WALL_TORCH));
    private static final DeferredHolder<PartConverter, PartConverter> LEVER_CONVERTER = PART_CONVERTERS.register("lever", () -> new Converter<LeverPart>(LeverPart::new, LeverPart::new, Items.LEVER, Blocks.LEVER));
    private static final DeferredHolder<PartConverter, PartConverter> STONE_BUTTON_CONVERTER = PART_CONVERTERS.register("stone_button", () -> new Converter<ButtonPart.StoneButtonPart>(ButtonPart.StoneButtonPart::new, ButtonPart.StoneButtonPart::new, Items.STONE_BUTTON, Blocks.STONE_BUTTON));
    private static final DeferredHolder<PartConverter, PartConverter> POLISHED_BLACKSTONE_BUTTON_CONVERTER = PART_CONVERTERS.register("polished_blackstone_button", () -> new Converter<ButtonPart.PolishedBlackstoneButtonPart>(ButtonPart.PolishedBlackstoneButtonPart::new, ButtonPart.PolishedBlackstoneButtonPart::new, Items.POLISHED_BLACKSTONE_BUTTON, Blocks.POLISHED_BLACKSTONE_BUTTON));
    private static final DeferredHolder<PartConverter, PartConverter> OAK_BUTTON_CONVERTER = PART_CONVERTERS.register("oak_button", () -> new Converter<ButtonPart.OakButtonPart>(ButtonPart.OakButtonPart::new, ButtonPart.OakButtonPart::new, Items.OAK_BUTTON, Blocks.OAK_BUTTON));
    private static final DeferredHolder<PartConverter, PartConverter> SPRUCE_BUTTON_CONVERTER = PART_CONVERTERS.register("spruce_button", () -> new Converter<ButtonPart.SpruceButtonPart>(ButtonPart.SpruceButtonPart::new, ButtonPart.SpruceButtonPart::new, Items.SPRUCE_BUTTON, Blocks.SPRUCE_BUTTON));
    private static final DeferredHolder<PartConverter, PartConverter> BIRCH_BUTTON_CONVERTER = PART_CONVERTERS.register("birch_button", () -> new Converter<ButtonPart.BirchButtonPart>(ButtonPart.BirchButtonPart::new, ButtonPart.BirchButtonPart::new, Items.BIRCH_BUTTON, Blocks.BIRCH_BUTTON));
    private static final DeferredHolder<PartConverter, PartConverter> JUNGLE_BUTTON_CONVERTER = PART_CONVERTERS.register("jungle_button", () -> new Converter<ButtonPart.JungleButtonPart>(ButtonPart.JungleButtonPart::new, ButtonPart.JungleButtonPart::new, Items.JUNGLE_BUTTON, Blocks.JUNGLE_BUTTON));
    private static final DeferredHolder<PartConverter, PartConverter> ACACIA_BUTTON_CONVERTER = PART_CONVERTERS.register("acacia_button", () -> new Converter<ButtonPart.AcaciaButtonPart>(ButtonPart.AcaciaButtonPart::new, ButtonPart.AcaciaButtonPart::new, Items.ACACIA_BUTTON, Blocks.ACACIA_BUTTON));
    private static final DeferredHolder<PartConverter, PartConverter> DARK_OAK_BUTTON_CONVERTER = PART_CONVERTERS.register("dark_oak_button", () -> new Converter<ButtonPart.DarkOakButtonPart>(ButtonPart.DarkOakButtonPart::new, ButtonPart.DarkOakButtonPart::new, Items.DARK_OAK_BUTTON, Blocks.DARK_OAK_BUTTON));
    private static final DeferredHolder<PartConverter, PartConverter> CRIMSON_BUTTON_CONVERTER = PART_CONVERTERS.register("crimson_button", () -> new Converter<ButtonPart.CrimsonButtonPart>(ButtonPart.CrimsonButtonPart::new, ButtonPart.CrimsonButtonPart::new, Items.CRIMSON_BUTTON, Blocks.CRIMSON_BUTTON));
    private static final DeferredHolder<PartConverter, PartConverter> WARPED_BUTTON_CONVERTER = PART_CONVERTERS.register("warped_button", () -> new Converter<ButtonPart.WarpedButtonPart>(ButtonPart.WarpedButtonPart::new, ButtonPart.WarpedButtonPart::new, Items.WARPED_BUTTON, Blocks.WARPED_BUTTON));

    public static void init(IEventBus modBus) {
        MULTIPART_TYPES.register(modBus);
        PART_CONVERTERS.register(modBus);
    }

    private static class Converter<T extends McStatePart>
    extends PartConverter {
        private final Supplier<T> factory;
        private final Function<BlockState, T> blockFactory;
        private final Item item;
        private final Block[] blocks;

        private Converter(Supplier<T> factory, Function<BlockState, T> blockFactory, Item item, Block ... blocks) {
            this.factory = factory;
            this.blockFactory = blockFactory;
            this.item = item;
            this.blocks = blocks;
        }

        @Override
        public PartConverter.ConversionResult<Collection<MultiPart>> convert(LevelAccessor world, BlockPos pos, BlockState state) {
            if (this.blocks.length == 0) {
                return PartConverter.emptyResultList();
            }
            if (ArrayUtils.contains((Object[])this.blocks, (Object)state.getBlock())) {
                return PartConverter.ConversionResult.success(Collections.singleton((MultiPart)this.blockFactory.apply(state)));
            }
            return super.convert(world, pos, state);
        }

        @Override
        public PartConverter.ConversionResult<MultiPart> convert(MultipartPlaceContext context) {
            if (context.getItemInHand().getItem() != this.item) {
                return Converter.emptyResult();
            }
            MultiPart result = ((McStatePart)this.factory.get()).setStateOnPlacement(context);
            if (result != null) {
                return PartConverter.ConversionResult.success(result);
            }
            return super.convert(context);
        }
    }
}

