/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.minecraft;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.Cuboid6;
import codechicken.multipart.api.NormalOcclusionTest;
import codechicken.multipart.api.part.BaseMultipart;
import codechicken.multipart.api.part.IconHitEffectsPart;
import codechicken.multipart.api.part.ModelRenderPart;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.api.part.NormalOcclusionPart;
import codechicken.multipart.util.PartRayTraceResult;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public abstract class McStatePart
extends BaseMultipart
implements NormalOcclusionPart,
ModelRenderPart,
IconHitEffectsPart {
    public BlockState state;

    public McStatePart() {
        this.state = this.defaultBlockState();
    }

    public McStatePart(BlockState state) {
        this.state = state;
    }

    public abstract BlockState defaultBlockState();

    public abstract ItemStack getDropStack();

    @Override
    public Iterable<ItemStack> getDrops() {
        return Collections.singletonList(this.getDropStack());
    }

    @Override
    public ItemStack getCloneStack(PartRayTraceResult hit) {
        return this.getDropStack();
    }

    @Override
    public void save(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put("state", (Tag)NbtUtils.writeBlockState((BlockState)this.state));
    }

    @Override
    public void load(CompoundTag tag, HolderLookup.Provider registries) {
        this.state = NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), (CompoundTag)tag.getCompound("state"));
    }

    @Override
    public void writeDesc(MCDataOutput packet) {
        packet.writeCompoundNBT(NbtUtils.writeBlockState((BlockState)this.state));
    }

    @Override
    public void readDesc(MCDataInput packet) {
        this.state = NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), (CompoundTag)packet.readCompoundNBT());
    }

    @Override
    public BlockState getCurrentState() {
        return this.state;
    }

    @Nullable
    public MultiPart setStateOnPlacement(BlockPlaceContext context) {
        BlockState state = this.defaultBlockState().getBlock().getStateForPlacement(context);
        if (state != null) {
            this.state = state;
            return this;
        }
        return null;
    }

    @Override
    public float getStrength(Player player, PartRayTraceResult hit) {
        return this.state.getDestroyProgress(player, (BlockGetter)player.level(), new BlockPos(0, -1, 0));
    }

    @Override
    public int getLightEmission() {
        return this.state.getLightEmission();
    }

    @Override
    public VoxelShape getShape(CollisionContext context) {
        return this.state.getShape((BlockGetter)this.level(), this.pos(), context);
    }

    @Override
    public VoxelShape getCollisionShape(CollisionContext context) {
        return this.state.getCollisionShape((BlockGetter)this.level(), this.pos(), context);
    }

    @Override
    public VoxelShape getRenderOcclusionShape() {
        return this.state.getOcclusionShape((BlockGetter)this.level(), this.pos());
    }

    @Override
    public VoxelShape getInteractionShape() {
        return this.state.getInteractionShape((BlockGetter)this.level(), this.pos());
    }

    @Override
    public VoxelShape getOcclusionShape() {
        VoxelShape cShape = this.state.getCollisionShape(null, null);
        return cShape.isEmpty() ? this.state.getShape(null, null) : cShape;
    }

    @Override
    public VoxelShape getBlockSupportShape() {
        return this.state.getBlockSupportShape((BlockGetter)this.level(), this.pos());
    }

    @Override
    public VoxelShape getVisualShape(CollisionContext context) {
        return this.state.getVisualShape((BlockGetter)this.level(), this.pos(), context);
    }

    @Override
    public boolean occlusionTest(MultiPart nPart) {
        return NormalOcclusionTest.test(this, nPart);
    }

    @Override
    public SoundType getPlacementSound(UseOnContext context) {
        return this.state.getSoundType((LevelReader)this.level(), this.pos(), (Entity)context.getPlayer());
    }

    @Override
    public Cuboid6 getBounds() {
        return new Cuboid6(this.getShape(CollisionContext.empty()).bounds());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TextureAtlasSprite getBreakingIcon(PartRayTraceResult hit) {
        return this.getBrokenIcon(hit.getDirection().ordinal());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TextureAtlasSprite getBrokenIcon(int side) {
        return Minecraft.getInstance().getBlockRenderer().getBlockModelShaper().getBlockModel(this.getCurrentState()).getParticleIcon(this.getModelData());
    }
}

