/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.client;

import codechicken.lib.render.RenderUtils;
import codechicken.lib.vec.Matrix4;
import codechicken.multipart.api.MultipartClientRegistry;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.api.part.render.PartRenderer;
import codechicken.multipart.block.BlockMultipart;
import codechicken.multipart.block.TileMultipart;
import codechicken.multipart.util.PartRayTraceResult;
import com.mojang.blaze3d.vertex.PoseStack;
import net.covers1624.quack.util.SneakyUtils;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.common.NeoForge;

public class ClientEventHandler {
    public static void init() {
        NeoForge.EVENT_BUS.addListener(ClientEventHandler::onDrawBlockHighlight);
    }

    private static void onDrawBlockHighlight(RenderHighlightEvent.Block event) {
        Camera camera = event.getCamera();
        PoseStack mStack = event.getPoseStack();
        MultiBufferSource buffers = event.getMultiBufferSource();
        float partialTicks = event.getDeltaTracker().getGameTimeDeltaPartialTick(true);
        BlockHitResult target = event.getTarget();
        if (!(target instanceof PartRayTraceResult)) {
            return;
        }
        PartRayTraceResult hit = (PartRayTraceResult)target;
        TileMultipart tile = BlockMultipart.getTile((BlockGetter)camera.getEntity().level(), target.getBlockPos());
        if (tile == null) {
            return;
        }
        MultiPart part = hit.part;
        PartRenderer<MultiPart> renderer = MultipartClientRegistry.getRenderer(part.getType());
        if (renderer == null || !renderer.drawHighlight((MultiPart)SneakyUtils.unsafeCast((Object)part), hit, camera, mStack, buffers, partialTicks)) {
            Matrix4 mat = new Matrix4(mStack);
            mat.translate((Vec3i)hit.getBlockPos());
            VoxelShape shape = hit.hitShape;
            if (shape == null) {
                shape = part.getShape(CollisionContext.empty());
            }
            RenderUtils.bufferShapeHitBox((Matrix4)mat, (MultiBufferSource)buffers, (Camera)camera, (VoxelShape)shape);
        }
        event.setCanceled(true);
    }
}

