/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.api.part.render;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.buffer.BakedQuadVertexBuilder;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.util.PartRayTraceResult;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;

public interface PartRenderer<T extends MultiPart> {
    default public List<BakedQuad> getQuads(T part, @Nullable Direction side, RandomSource rand, ModelData data, @Nullable RenderType renderType) {
        if (side != null) {
            return List.of();
        }
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.hackyReallyDontComputeLighting = true;
        ccrs.reset();
        BakedQuadVertexBuilder builder = new BakedQuadVertexBuilder();
        ccrs.bind((VertexConsumer)builder, DefaultVertexFormat.BLOCK);
        ccrs.lightMatrix.locate((BlockAndTintGetter)part.level(), part.pos());
        if (renderType == null) {
            this.renderBreaking(part, ccrs);
        } else {
            this.renderStatic(part, renderType, ccrs);
        }
        ccrs.hackyReallyDontComputeLighting = false;
        ccrs.reset();
        return builder.bake();
    }

    @Deprecated
    default public void renderStatic(T part, @Nullable RenderType layer, CCRenderState ccrs) {
    }

    @Deprecated
    default public void renderBreaking(T part, CCRenderState ccrs) {
        this.renderStatic(part, null, ccrs);
    }

    default public void renderDynamic(T part, PoseStack pStack, MultiBufferSource buffers, int packedLight, int packedOverlay, float partialTicks) {
    }

    default public boolean drawHighlight(T part, PartRayTraceResult hit, Camera camera, PoseStack pStack, MultiBufferSource buffers, float partialTicks) {
        return false;
    }
}

