/*
 * Decompiled with CFR 0.152.
 */
package codechicken.microblock.item;

import codechicken.lib.raytracer.RayTracer;
import codechicken.microblock.api.MicroMaterial;
import codechicken.microblock.init.CBMicroblockModContent;
import codechicken.microblock.item.MicroMaterialComponent;
import codechicken.microblock.part.ExecutablePlacement;
import codechicken.microblock.part.MicroblockPlacement;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.phys.BlockHitResult;

public class ItemMicroBlock
extends Item {
    public ItemMicroBlock(Item.Properties properties) {
        super(properties);
    }

    public Component getName(ItemStack stack) {
        MicroMaterialComponent component = MicroMaterialComponent.getComponent(stack);
        if (component == null || component.factory() == null) {
            return Component.literal((String)"Unnamed");
        }
        return Component.translatable((String)("item." + component.factory().getRegistryName().toString().replace(':', '.') + "." + component.size()), (Object[])new Object[]{component.material().getLocalizedName()});
    }

    public InteractionResult useOn(UseOnContext ctx) {
        Player player = ctx.getPlayer();
        Level level = ctx.getLevel();
        ItemStack stack = player.getItemInHand(ctx.getHand());
        MicroMaterialComponent component = MicroMaterialComponent.getComponent(stack);
        if (component == null || component.factory() == null) {
            return InteractionResult.FAIL;
        }
        BlockHitResult hit = RayTracer.retraceBlock((BlockGetter)level, (Player)player, (BlockPos)ctx.getClickedPos());
        if (hit != null) {
            ExecutablePlacement placement = new MicroblockPlacement(player, ctx.getHand(), hit, component.size(), component.material(), !player.getAbilities().instabuild, component.factory().placementProperties()).calculate();
            if (placement == null) {
                return InteractionResult.FAIL;
            }
            if (!level.isClientSide) {
                SoundType sound;
                placement.place(level, player, stack);
                if (!player.getAbilities().instabuild) {
                    placement.consume(level, player, stack);
                }
                if ((sound = component.material().getSound()) != null) {
                    level.playSound(null, (double)placement.pos.getX() + 0.5, (double)placement.pos.getY() + 0.5, (double)placement.pos.getZ() + 0.5, sound.getPlaceSound(), SoundSource.BLOCKS, (sound.getVolume() + 1.0f) / 2.0f, sound.getPitch() * 0.8f);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public static ItemStack create(int factoryId, int size, MicroMaterial material) {
        return ItemMicroBlock.createStack(1, factoryId, size, material);
    }

    public static ItemStack createStack(int amount, int factoryId, int size, MicroMaterial material) {
        ItemStack stack = new ItemStack((ItemLike)CBMicroblockModContent.MICRO_BLOCK_ITEM.get(), amount);
        stack.set(CBMicroblockModContent.MICRO_MATERIAL_COMPONENT, (Object)new MicroMaterialComponent(factoryId, size, material));
        return stack;
    }
}

