/*
 * Decompiled with CFR 0.152.
 */
package codechicken.microblock.api;

import codechicken.microblock.api.MicroMaterialClient;
import codechicken.microblock.util.MicroMaterialRegistry;
import com.mojang.serialization.Codec;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.block.SoundType;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.data.loading.DatagenModLoader;
import net.neoforged.neoforge.registries.RegistryBuilder;
import org.jetbrains.annotations.Nullable;

public abstract class MicroMaterial {
    public static final ResourceKey<Registry<MicroMaterial>> MULTIPART_TYPES = ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cb_microblock", (String)"micro_material"));
    public static final Registry<MicroMaterial> REGISTRY = new RegistryBuilder(MULTIPART_TYPES).sync(true).create();
    public static final Codec<MicroMaterial> CODEC = REGISTRY.byNameCodec();
    public static final StreamCodec<RegistryFriendlyByteBuf, MicroMaterial> STREAM_CODEC = ByteBufCodecs.registry(MULTIPART_TYPES);
    @Nullable
    Object renderProperties;

    public MicroMaterial() {
        this.initClient();
    }

    public ResourceLocation getRegistryName() {
        return Objects.requireNonNull(MicroMaterialRegistry.microMaterials().getKey((Object)this));
    }

    public abstract boolean isTransparent();

    public abstract int getLightEmission();

    public abstract float getStrength(Player var1);

    public abstract Component getLocalizedName();

    public abstract ItemStack getItem();

    @Nullable
    public abstract SoundType getSound();

    public abstract float getExplosionResistance(BlockGetter var1, BlockPos var2, Explosion var3);

    public void initializeClient(Consumer<MicroMaterialClient> cons) {
    }

    private void initClient() {
        if (FMLEnvironment.dist.isClient() && !DatagenModLoader.isRunningDataGen()) {
            this.initializeClient(props -> {
                this.renderProperties = props;
            });
        }
    }
}

