/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.handcrafted.common.blocks;

import earth.terrarium.handcrafted.common.blocks.DiningBenchBlock;
import earth.terrarium.handcrafted.common.blocks.base.properties.ColorProperty;
import earth.terrarium.handcrafted.common.blocks.base.properties.DirectionalBlockProperty;
import earth.terrarium.handcrafted.common.constants.ConstantComponents;
import earth.terrarium.handcrafted.common.utils.InteractionUtils;
import earth.terrarium.handcrafted.common.utils.TooltipUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FancyBedBlock
extends BedBlock {
    public static final EnumProperty<BedPart> PART = BlockStateProperties.BED_PART;
    public static final BooleanProperty OCCUPIED = BlockStateProperties.OCCUPIED;
    public static final EnumProperty<DirectionalBlockProperty> SHAPE = EnumProperty.create((String)"shape", DirectionalBlockProperty.class);
    public static final EnumProperty<ColorProperty> COLOR = EnumProperty.create((String)"color", ColorProperty.class);
    public static final VoxelShape VOXEL_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);

    public FancyBedBlock(BlockBehaviour.Properties properties) {
        super(DyeColor.WHITE, properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(PART, (Comparable)BedPart.FOOT)).setValue((Property)OCCUPIED, (Comparable)Boolean.valueOf(false))).setValue(SHAPE, (Comparable)((Object)DirectionalBlockProperty.SINGLE))).setValue(COLOR, (Comparable)((Object)ColorProperty.WHITE)));
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moved) {
        if (!level.isClientSide() && state.getBlock() != newState.getBlock() && state.getValue(COLOR) != ColorProperty.WHITE) {
            Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)(state.getValue(PART) == BedPart.FOOT ? ((ColorProperty)((Object)state.getValue(COLOR))).toSheet() : ((ColorProperty)((Object)state.getValue(COLOR))).toCushion()));
        }
        super.onRemove(state, level, pos, newState, moved);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, PART, OCCUPIED, SHAPE, COLOR});
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return null;
    }

    @NotNull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return VOXEL_SHAPE;
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (direction == this.getNeighbourDirection((BedPart)state.getValue(PART), (Direction)state.getValue((Property)FACING))) {
            return neighborState.is((Block)this) && neighborState.getValue(PART) != state.getValue(PART) ? (BlockState)((BlockState)state.setValue((Property)OCCUPIED, (Comparable)((Boolean)neighborState.getValue((Property)OCCUPIED)))).setValue(SHAPE, (Comparable)((Object)FancyBedBlock.getShape((Block)this, (Direction)state.getValue((Property)FACING), (BlockGetter)level, pos))) : Blocks.AIR.defaultBlockState();
        }
        return super.updateShape((BlockState)state.setValue(SHAPE, (Comparable)((Object)FancyBedBlock.getShape((Block)this, (Direction)state.getValue((Property)FACING), (BlockGetter)level, pos))), direction, neighborState, level, pos, neighborPos);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getHorizontalDirection();
        BlockPos pos = context.getClickedPos();
        BlockPos relativePos = pos.relative(direction);
        Level level = context.getLevel();
        return level.getBlockState(relativePos).canBeReplaced(context) && level.getWorldBorder().isWithinBounds(relativePos) ? (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction)).setValue(SHAPE, (Comparable)((Object)FancyBedBlock.getShape((Block)this, direction, (BlockGetter)level, pos))) : null;
    }

    private Direction getNeighbourDirection(BedPart part, Direction direction) {
        return part == BedPart.FOOT ? direction : direction.getOpposite();
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemInteractionResult result;
        ItemInteractionResult itemInteractionResult = result = state.getValue(PART) == BedPart.HEAD ? InteractionUtils.interactCushion(state, level, pos, player, stack, COLOR) : InteractionUtils.interactSheet(state, level, pos, player, stack, COLOR);
        if (result != ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION) {
            return result;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public static DirectionalBlockProperty getShape(Block block, Direction direction, BlockGetter level, BlockPos pos) {
        boolean check2;
        BlockState state1 = level.getBlockState(pos.relative(direction.getClockWise()));
        BlockState state2 = level.getBlockState(pos.relative(direction.getClockWise().getOpposite()));
        boolean check1 = state1.is(block) && state1.getValue((Property)DiningBenchBlock.FACING) != direction;
        boolean bl = check2 = state2.is(block) && state2.getValue((Property)DiningBenchBlock.FACING) != direction;
        if (!state1.is(block) && !state2.is(block)) {
            return DirectionalBlockProperty.SINGLE;
        }
        if (check1 && state2.is(block)) {
            return DirectionalBlockProperty.RIGHT;
        }
        if (check2 && state1.is(block)) {
            return DirectionalBlockProperty.LEFT;
        }
        if (check1) {
            return DirectionalBlockProperty.SINGLE;
        }
        if (check2) {
            return DirectionalBlockProperty.SINGLE;
        }
        if (!state1.is(block)) {
            return DirectionalBlockProperty.RIGHT;
        }
        if (!state2.is(block)) {
            return DirectionalBlockProperty.LEFT;
        }
        return DirectionalBlockProperty.MIDDLE;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        TooltipUtils.addDescriptionComponent(tooltipComponents, ConstantComponents.BED_PILLOW, ConstantComponents.BED_SHEET);
    }
}

