/*
 * Decompiled with CFR 0.152.
 */
package betterdays.time.effects;

import betterdays.config.ConfigHandler;
import betterdays.time.SleepStatus;
import betterdays.time.TimeContext;
import betterdays.time.effects.AbstractTimeEffect;
import betterdays.time.effects.EffectCondition;

public class RandomTickSleepEffect
extends AbstractTimeEffect {
    @Override
    public void onTimeTick(TimeContext context) {
        this.updateRandomTickSpeed(context);
    }

    private void updateRandomTickSpeed(TimeContext context) {
        EffectCondition condition = ConfigHandler.Common.randomTickEffect();
        if (condition == EffectCondition.NEVER) {
            return;
        }
        int speed = ConfigHandler.Common.baseRandomTickSpeed();
        SleepStatus sleepStatus = context.getTimeService().sleepStatus;
        if (condition == EffectCondition.ALWAYS || condition == EffectCondition.SLEEPING && !sleepStatus.allAwake()) {
            long timeDelta = context.getTimeDelta().longValue();
            speed = timeDelta > 1L ? (int)((long)speed * timeDelta) : (int)((double)speed * context.getTimeService().getTimeSpeed(context.getCurrentTime()));
        }
        if (speed < 1) {
            speed = 1;
        }
        context.getLevel().setRandomTickSpeed(speed);
    }
}

