/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.corpsecurioscompat.mixin;

import com.leclowndu93150.corpsecurioscompat.Config;
import com.leclowndu93150.corpsecurioscompat.CuriosSlotDataComponent;
import de.maxhenkel.gravestone.blocks.GraveStoneBlock;
import de.maxhenkel.gravestone.corelib.death.Death;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

@Mixin(value={GraveStoneBlock.class})
public abstract class GraveStoneBlockMixin {
    @Overwrite(remap=false)
    public NonNullList<ItemStack> fillPlayerInventory(Player player, Death death) {
        NonNullList unaddedItems = NonNullList.create();
        Optional curiosHandler = CuriosApi.getCuriosInventory((LivingEntity)player);
        if (curiosHandler.isPresent()) {
            this.handleCuriosTransfer((ICuriosItemHandler)curiosHandler.get(), death, (NonNullList<ItemStack>)unaddedItems);
        }
        this.handleNormalInventoryTransfer(player, death, (NonNullList<ItemStack>)unaddedItems);
        NonNullList overflow = NonNullList.create();
        for (ItemStack stack : unaddedItems) {
            if (player.getInventory().add(stack)) continue;
            overflow.add((Object)stack);
        }
        death.getAdditionalItems().clear();
        return overflow;
    }

    @Unique
    private void handleCuriosTransfer(ICuriosItemHandler curiosHandler, Death death, NonNullList<ItemStack> overflow) {
        this.transferCuriosFromInventory((NonNullList<ItemStack>)death.getMainInventory(), curiosHandler, overflow);
        this.transferCuriosFromInventory((NonNullList<ItemStack>)death.getArmorInventory(), curiosHandler, overflow);
        this.transferCuriosFromInventory((NonNullList<ItemStack>)death.getOffHandInventory(), curiosHandler, overflow);
        this.transferCuriosFromInventory((NonNullList<ItemStack>)death.getAdditionalItems(), curiosHandler, overflow);
    }

    @Unique
    private void transferCuriosFromInventory(NonNullList<ItemStack> inventory, ICuriosItemHandler curiosHandler, NonNullList<ItemStack> overflow) {
        for (int i = 0; i < inventory.size(); ++i) {
            ItemStack stack = (ItemStack)inventory.get(i);
            if (stack.isEmpty() || !this.tryTransferPreviouslyEquippedCurio(stack, curiosHandler.getCurios())) continue;
            inventory.set(i, (Object)ItemStack.EMPTY);
        }
    }

    @Unique
    private boolean tryTransferPreviouslyEquippedCurio(ItemStack stack, Map<String, ICurioStacksHandler> curios) {
        if (stack.isEmpty()) {
            return false;
        }
        if (CuriosApi.getCuriosHelper().getCurioTags(stack.getItem()).isEmpty()) {
            return false;
        }
        CuriosSlotDataComponent.CurioSlotData slotData = (CuriosSlotDataComponent.CurioSlotData)stack.get((DataComponentType)CuriosSlotDataComponent.CURIO_SLOT_DATA.get());
        if (slotData == null || !slotData.wasEquipped()) {
            return false;
        }
        if (Config.isItemBlacklisted(stack.getItem())) {
            return false;
        }
        String slotType = slotData.slotType();
        int slotIndex = slotData.slotIndex();
        ICurioStacksHandler handler = curios.get(slotType);
        if (handler != null && slotIndex >= 0 && slotIndex < handler.getSlots()) {
            try {
                ItemStack existingStack = handler.getStacks().getStackInSlot(slotIndex);
                if (existingStack.isEmpty()) {
                    ItemStack cleanStack = stack.copy();
                    cleanStack.remove((DataComponentType)CuriosSlotDataComponent.CURIO_SLOT_DATA.get());
                    handler.getStacks().setStackInSlot(slotIndex, cleanStack);
                    return true;
                }
                CuriosSlotDataComponent.CurioSlotData existingSlotData = (CuriosSlotDataComponent.CurioSlotData)existingStack.get((DataComponentType)CuriosSlotDataComponent.CURIO_SLOT_DATA.get());
                if (!(existingSlotData == null || slotType.equals(existingSlotData.slotType()) && slotIndex == existingSlotData.slotIndex())) {
                    handler.getStacks().setStackInSlot(slotIndex, ItemStack.EMPTY);
                    ItemStack cleanStack = stack.copy();
                    cleanStack.remove((DataComponentType)CuriosSlotDataComponent.CURIO_SLOT_DATA.get());
                    handler.getStacks().setStackInSlot(slotIndex, cleanStack);
                    this.tryFindAlternativeSlot(existingStack, curios);
                    return true;
                }
            }
            catch (IndexOutOfBoundsException e) {
                return this.tryFindAlternativeSlot(stack, curios);
            }
        }
        return this.tryFindAlternativeSlot(stack, curios);
    }

    @Unique
    private boolean tryFindAlternativeSlot(ItemStack stack, Map<String, ICurioStacksHandler> curios) {
        CuriosSlotDataComponent.CurioSlotData slotData = (CuriosSlotDataComponent.CurioSlotData)stack.get((DataComponentType)CuriosSlotDataComponent.CURIO_SLOT_DATA.get());
        if (slotData == null || !slotData.wasEquipped()) {
            return false;
        }
        for (Map.Entry<String, ICurioStacksHandler> entry : curios.entrySet()) {
            if (!CuriosApi.getCuriosHelper().getCurioTags(stack.getItem()).contains(entry.getKey())) continue;
            ICurioStacksHandler handler = entry.getValue();
            for (int slot = 0; slot < handler.getSlots(); ++slot) {
                try {
                    if (!handler.getStacks().getStackInSlot(slot).isEmpty()) continue;
                    ItemStack cleanStack = stack.copy();
                    cleanStack.remove((DataComponentType)CuriosSlotDataComponent.CURIO_SLOT_DATA.get());
                    handler.getStacks().setStackInSlot(slot, cleanStack);
                    return true;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    @Unique
    private void handleNormalInventoryTransfer(Player player, Death death, NonNullList<ItemStack> overflow) {
        this.transferInventory((NonNullList<ItemStack>)death.getMainInventory(), (NonNullList<ItemStack>)player.getInventory().items, overflow);
        this.transferInventory((NonNullList<ItemStack>)death.getArmorInventory(), (NonNullList<ItemStack>)player.getInventory().armor, overflow);
        this.transferInventory((NonNullList<ItemStack>)death.getOffHandInventory(), (NonNullList<ItemStack>)player.getInventory().offhand, overflow);
        death.getAdditionalItems().forEach(arg_0 -> overflow.add(arg_0));
    }

    @Unique
    private void transferInventory(NonNullList<ItemStack> source, NonNullList<ItemStack> destination, NonNullList<ItemStack> overflow) {
        for (int i = 0; i < source.size() && i < destination.size(); ++i) {
            CuriosSlotDataComponent.CurioSlotData slotData;
            ItemStack stack = (ItemStack)source.get(i);
            if (stack.isEmpty() || (slotData = (CuriosSlotDataComponent.CurioSlotData)stack.get((DataComponentType)CuriosSlotDataComponent.CURIO_SLOT_DATA.get())) != null && slotData.wasEquipped()) continue;
            ItemStack currentStack = (ItemStack)destination.get(i);
            if (!currentStack.isEmpty()) {
                overflow.add((Object)currentStack);
            }
            destination.set(i, (Object)stack);
            source.set(i, (Object)ItemStack.EMPTY);
        }
    }
}

