/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.corpsecurioscompat;

import com.leclowndu93150.baguettelib.event.entity.death.PlayerDeathEvent;
import com.leclowndu93150.corpsecurioscompat.CuriosSlotDataComponent;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

@EventBusSubscriber(modid="gravestonecurioscompat")
public class DeathEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onPlayerDeathPre(PlayerDeathEvent.Pre event) {
        Player player = event.getPlayer();
        Optional curioHandlerOptional = CuriosApi.getCuriosInventory((LivingEntity)player);
        if (!curioHandlerOptional.isPresent()) {
            return;
        }
        ICuriosItemHandler handler = (ICuriosItemHandler)curioHandlerOptional.get();
        Map curios = handler.getCurios();
        for (Map.Entry entry : curios.entrySet()) {
            ItemStack stack;
            int i;
            String slotType = (String)entry.getKey();
            ICurioStacksHandler stackHandler = (ICurioStacksHandler)entry.getValue();
            for (i = 0; i < stackHandler.getSlots(); ++i) {
                stack = stackHandler.getStacks().getStackInSlot(i);
                if (stack.isEmpty()) continue;
                DeathEventHandler.setSlotData(stack, slotType, i, true);
            }
            for (i = 0; i < stackHandler.getCosmeticStacks().getSlots(); ++i) {
                stack = stackHandler.getCosmeticStacks().getStackInSlot(i);
                if (stack.isEmpty()) continue;
                DeathEventHandler.setSlotData(stack, slotType, i, true);
            }
        }
    }

    private static void setSlotData(ItemStack stack, String slotType, int slotIndex, boolean wasEquipped) {
        CuriosSlotDataComponent.CurioSlotData slotData = new CuriosSlotDataComponent.CurioSlotData(slotType, slotIndex, wasEquipped);
        stack.set((DataComponentType)CuriosSlotDataComponent.CURIO_SLOT_DATA.get(), (Object)slotData);
    }
}

