/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.lib;

import mrtjp.projectred.lib.Vec2;

public class Size {
    public static final Size ZERO = new Size(0, 0);
    public static final Size INFINITE = new Size(Integer.MAX_VALUE, Integer.MAX_VALUE);
    public final int width;
    public final int height;

    public Size(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public Size add(int width, int height) {
        return new Size(this.width + width, this.height + height);
    }

    public Size subtract(int width, int height) {
        return new Size(this.width - width, this.height - height);
    }

    public Size multiply(int width, int height) {
        return new Size(this.width * width, this.height * height);
    }

    public Size divide(int width, int height) {
        return new Size(this.width / width, this.height / height);
    }

    public Size add(Size size) {
        return this.add(size.width, size.height);
    }

    public Size subtract(Size size) {
        return this.subtract(size.width, size.height);
    }

    public Size multiply(Size size) {
        return this.multiply(size.width, size.height);
    }

    public Size divide(Size size) {
        return this.divide(size.width, size.height);
    }

    public Vec2 toVec2() {
        return new Vec2(this.width, this.height);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Size) {
            Size size = (Size)obj;
            return size.width == this.width && size.height == this.height;
        }
        return false;
    }

    public String toString() {
        return "Size[" + this.width + ", " + this.height + "]";
    }
}

