/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.tile;

import codechicken.lib.data.MCDataByteBuf;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.Vector3;
import java.util.Objects;
import mrtjp.projectred.core.tile.IBlockEventBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class ProjectRedBlockEntity
extends BlockEntity
implements IBlockEventBlockEntity {
    public ProjectRedBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.saveAdditional(tag, lookupProvider);
        this.saveToNBT(tag, lookupProvider);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.loadAdditional(tag, lookupProvider);
        this.loadFromNBT(tag, lookupProvider);
    }

    public final CompoundTag getUpdateTag(HolderLookup.Provider lookupProvider) {
        CompoundTag tag = super.getUpdateTag(lookupProvider);
        MCDataByteBuf out = new MCDataByteBuf();
        this.writeDesc((MCDataOutput)out);
        out.writeToNBT(tag, "descpkt");
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.handleUpdateTag(tag, lookupProvider);
        MCDataByteBuf in = MCDataByteBuf.readFromNBT((CompoundTag)tag, (String)"descpkt", (RegistryAccess)this.getLevel().registryAccess());
        this.readDesc((MCDataInput)in);
    }

    protected void pushBlockState() {
        if (!this.getBlockLevel().isClientSide) {
            BlockState currentState = this.getBlockLevel().getBlockState(this.getBlockPosition());
            BlockState newState = this.storeBlockState(currentState);
            this.getBlockLevel().setBlockAndUpdate(this.getBlockPosition(), newState);
        }
    }

    @Override
    public Level getBlockLevel() {
        return Objects.requireNonNull(this.getLevel());
    }

    @Override
    public BlockPos getBlockPosition() {
        return this.getBlockPos();
    }

    public static void dropItem(ItemStack stack, Level world, Vector3 pos) {
        ItemEntity item = new ItemEntity(world, pos.x, pos.y, pos.z, stack);
        item.setDeltaMovement(world.random.nextGaussian() * 0.05, world.random.nextGaussian() * 0.05 + 0.2, world.random.nextGaussian() * 0.05);
        item.setPickUpDelay(10);
        world.addFreshEntity((Entity)item);
    }

    public static void dropInventory(Container inventory, Level world, Vector3 pos) {
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (stack.isEmpty()) continue;
            ProjectRedBlockEntity.dropItem(stack, world, pos);
            inventory.setItem(i, ItemStack.EMPTY);
        }
    }

    public static void ejectItem(ItemStack stack, Level world, BlockPos pos, int dir, double velocity) {
        Vector3 dirVec = switch (dir) {
            case 0 -> new Vector3(0.0, -1.0, 0.0);
            case 1 -> new Vector3(0.0, 1.0, 0.0);
            case 2 -> new Vector3(0.0, 0.0, -1.0);
            case 3 -> new Vector3(0.0, 0.0, 1.0);
            case 4 -> new Vector3(-1.0, 0.0, 0.0);
            case 5 -> new Vector3(1.0, 0.0, 0.0);
            default -> throw new IllegalStateException("Unexpected value: " + dir);
        };
        Vector3 itemPos = Vector3.fromBlockPosCenter((BlockPos)pos).add(dirVec.copy().multiply(0.6));
        Vector3 itemMotion = dirVec.copy().multiply(velocity);
        ItemEntity item = new ItemEntity(world, itemPos.x, itemPos.y, itemPos.z, stack);
        item.setDeltaMovement(itemMotion.x, itemMotion.y, itemMotion.z);
        item.setPickUpDelay(10);
        world.addFreshEntity((Entity)item);
    }
}

