/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.client.particle;

import mrtjp.projectred.core.ProjectRedCore;
import mrtjp.projectred.core.client.particle.BaseActionParticle;
import mrtjp.projectred.core.client.particle.ChangeAlphaToAction;
import mrtjp.projectred.core.client.particle.GroupAction;
import mrtjp.projectred.core.client.particle.RemoveAction;
import mrtjp.projectred.core.client.particle.SequenceAction;
import net.minecraft.client.Minecraft;

public abstract class ParticleAction {
    protected boolean finished = false;
    private int runTime = 0;
    private double lastTime = 0.0;

    public void tick() {
        ++this.runTime;
    }

    public void operate(BaseActionParticle particle, float partialTick) {
        if (!this.finished) {
            double t;
            double d = t = Minecraft.getInstance().isPaused() ? this.lastTime : (double)((float)this.runTime + partialTick);
            if (t < this.lastTime) {
                ProjectRedCore.LOGGER.warn("ParticleAction time went backwards! {} -> {}", (Object)this.lastTime, (Object)t);
                return;
            }
            this.operateAction(particle, t);
            this.lastTime = t;
        }
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void reset() {
        this.finished = false;
        this.runTime = 0;
        this.lastTime = 0.0;
    }

    protected static boolean equalsT(double a, double b) {
        return Math.abs(a - b) < 1.0E-6;
    }

    protected double deltaTime(double time) {
        return time - this.lastTime;
    }

    public abstract ParticleAction copy();

    public abstract void beginAction(BaseActionParticle var1);

    public abstract void operateAction(BaseActionParticle var1, double var2);

    public static ParticleAction group(ParticleAction ... actions) {
        return new GroupAction(actions);
    }

    public static ParticleAction sequence(ParticleAction ... actions) {
        return new SequenceAction(actions);
    }

    public static ParticleAction changeAlphaTo(double targetAlpha, double duration) {
        return new ChangeAlphaToAction(targetAlpha, duration);
    }

    public static ParticleAction remove() {
        return new RemoveAction();
    }
}

