/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core;

import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.block.TileMultipart;
import codechicken.multipart.init.CBMultipartModContent;
import com.google.common.collect.HashMultimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mrtjp.projectred.core.part.IPropagationPart;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedStoneWireBlock;

public class RedstonePropagator {
    public static final int RISING = 0;
    public static final int DROPPING = 1;
    public static final int FORCE = 2;
    public static final int FORCED = 3;
    private static final LinkedList<PropagationRun> reusableRuns = new LinkedList();
    @Nullable
    private static PropagationRun currentRun = null;
    @Nullable
    private static PropagationRun finishingRun = null;
    private static boolean canRedwiresProvidePower = true;
    private static boolean canConnectRedwires = true;

    public static boolean canConnectRedwires() {
        return canConnectRedwires;
    }

    public static void setCanConnectRedwires(boolean canConnectRedwires) {
        RedstonePropagator.canConnectRedwires = canConnectRedwires;
    }

    public static boolean canRedwiresProvidePower() {
        return canRedwiresProvidePower;
    }

    public static void setDustProvidesPower(boolean dustProvidesPower) {
        ((RedStoneWireBlock)Blocks.REDSTONE_WIRE).shouldSignal = dustProvidesPower;
    }

    public static void setRedwiresProvidePower(boolean canRedwiresProvidePower) {
        RedstonePropagator.canRedwiresProvidePower = canRedwiresProvidePower;
    }

    public static void resetPowerFlags() {
        RedstonePropagator.setDustProvidesPower(true);
        RedstonePropagator.setRedwiresProvidePower(true);
        RedstonePropagator.setCanConnectRedwires(true);
    }

    public static void addNeighborChange(Level world, BlockPos sourcePos, BlockPos neighborPos) {
        assert (currentRun != null);
        RedstonePropagator.currentRun.neighborChanges.put((Object)world, (Object)neighborPos);
        if (!RedstonePropagator.currentRun.neighborChangeSources.containsKey(neighborPos)) {
            RedstonePropagator.currentRun.neighborChangeSources.put(neighborPos, sourcePos);
        }
    }

    public static void addPartChange(MultiPart part) {
        assert (currentRun != null);
        RedstonePropagator.currentRun.partChanges.put((Object)part.tile(), (Object)part);
    }

    public static void logCalculation() {
        if (finishingRun != null) {
            ++RedstonePropagator.finishingRun.recalcs;
        }
    }

    public static void propagateTo(IPropagationPart part, @Nullable IPropagationPart from, int mode) {
        if (currentRun != null) {
            currentRun.add(part, from, mode);
            return;
        }
        currentRun = reusableRuns.isEmpty() ? new PropagationRun() : reusableRuns.removeFirst();
        currentRun.add(part, from, mode);
        currentRun.executeRun(finishingRun);
    }

    public static void propagateTo(IPropagationPart part, int mode) {
        RedstonePropagator.propagateTo(part, null, mode);
    }

    public static void propagateAnalogDrop(IPropagationPart part) {
        assert (currentRun != null);
        currentRun.addAnalogDrop(part);
    }

    private static class PropagationRun {
        @Nullable
        private PropagationRun parent;
        @Nullable
        private IPropagationPart lastCaller;
        private int count = 0;
        private int recalcs = 0;
        HashMultimap<TileMultipart, MultiPart> partChanges = HashMultimap.create();
        HashMultimap<Level, BlockPos> neighborChanges = HashMultimap.create();
        HashMap<BlockPos, BlockPos> neighborChangeSources = new HashMap();
        List<Runnable> propagationTasks = new LinkedList<Runnable>();
        List<Runnable> analogDropPropagationTasks = new LinkedList<Runnable>();

        private PropagationRun() {
        }

        void clear() {
            this.partChanges.clear();
            this.neighborChanges.clear();
            this.neighborChangeSources.clear();
            this.count = 0;
            this.recalcs = 0;
            this.lastCaller = null;
            reusableRuns.add(this);
        }

        void executeRun(@Nullable PropagationRun parent) {
            this.parent = parent;
            currentRun = this;
            this.runLoop();
            this.finishRun();
        }

        void runLoop() {
            do {
                List<Runnable> pTasks = this.propagationTasks;
                this.propagationTasks = new LinkedList<Runnable>();
                pTasks.forEach(Runnable::run);
                if (!this.propagationTasks.isEmpty() || this.analogDropPropagationTasks.isEmpty()) continue;
                this.propagationTasks = this.analogDropPropagationTasks;
                this.analogDropPropagationTasks = new LinkedList<Runnable>();
            } while (!this.propagationTasks.isEmpty());
        }

        void finishRun() {
            currentRun = null;
            if (this.partChanges.isEmpty() && this.neighborChanges.isEmpty()) {
                finishingRun = this.parent;
                this.clear();
                return;
            }
            finishingRun = this;
            for (Map.Entry entry : this.partChanges.asMap().entrySet()) {
                Collection parts = (Collection)entry.getValue();
                for (MultiPart part : parts) {
                    ((IPropagationPart)part).onSignalUpdate();
                }
                ((TileMultipart)entry.getKey()).multiPartChange(parts);
            }
            for (Map.Entry entry : this.neighborChanges.asMap().entrySet()) {
                Level world = (Level)entry.getKey();
                Collection positions = (Collection)entry.getValue();
                for (BlockPos pos : positions) {
                    world.neighborChanged(pos, (Block)CBMultipartModContent.MULTIPART_BLOCK.get(), this.neighborChangeSources.get(pos));
                }
            }
            finishingRun = this.parent;
            this.clear();
        }

        void add(IPropagationPart part, @Nullable IPropagationPart from, int mode) {
            if (from != this.lastCaller) {
                this.lastCaller = from;
                ++this.count;
            }
            this.propagationTasks.add(() -> part.updateAndPropagate(from, mode));
        }

        void addAnalogDrop(IPropagationPart part) {
            this.analogDropPropagationTasks.add(() -> part.updateAndPropagate(null, 0));
        }
    }
}

