/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_paintings.network.payload.c2s;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.conczin.immersive_paintings.Main;
import net.conczin.immersive_paintings.entity.ImmersivePaintingEntity;
import net.conczin.immersive_paintings.network.payload.ImmersivePayload;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public record PaintingEditPayload(int entityId, Map<Option, String> options) implements ImmersivePayload
{
    public static final CustomPacketPayload.Type<PaintingEditPayload> TYPE = new CustomPacketPayload.Type(Main.locate("painting_edit"));
    public static final StreamCodec<FriendlyByteBuf, PaintingEditPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, PaintingEditPayload::entityId, (StreamCodec)ByteBufCodecs.map(HashMap::new, Option.STREAM_CODEC, (StreamCodec)ByteBufCodecs.STRING_UTF8), PaintingEditPayload::options, PaintingEditPayload::new);

    @Override
    public void handle(Player player, ImmersivePayload.Runner runner) {
        int entityId = this.entityId();
        Map<Option, String> options = this.options();
        runner.run(() -> {
            Entity entity = player.level().getEntity(entityId);
            if (entity instanceof ImmersivePaintingEntity) {
                ImmersivePaintingEntity painting = (ImmersivePaintingEntity)entity;
                options.forEach((option, value) -> {
                    switch (option.ordinal()) {
                        case 0: {
                            painting.setMotive(ResourceLocation.parse((String)value));
                            break;
                        }
                        case 1: {
                            painting.setFrame(ResourceLocation.parse((String)value));
                            break;
                        }
                        case 2: {
                            painting.setMaterial(ResourceLocation.parse((String)value));
                            break;
                        }
                    }
                });
            }
        });
    }

    public CustomPacketPayload.Type<PaintingEditPayload> type() {
        return TYPE;
    }

    public static enum Option implements StringRepresentable
    {
        MOTIVE,
        FRAME,
        MATERIAL,
        DELETE;

        private static final Codec<Option> CODEC;
        public static final StreamCodec<ByteBuf, Option> STREAM_CODEC;

        public String getSerializedName() {
            return this.name();
        }

        static {
            CODEC = StringRepresentable.fromValues(Option::values);
            STREAM_CODEC = ByteBufCodecs.fromCodec(CODEC);
        }
    }
}

