/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.client.particles;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.WaterDropParticle;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.FastColor;

public class ColoredSplashParticle
extends WaterDropParticle {
    private final int lightLevel;

    ColoredSplashParticle(ClientLevel clientLevel, double d, double e, double f, int light) {
        super(clientLevel, d, e, f);
        this.gravity = 0.04f;
        this.lightLevel = light;
    }

    protected int getLightColor(float partialTick) {
        int lightColor = super.getLightColor(partialTick);
        int sky = LightTexture.sky((int)lightColor);
        int block = LightTexture.block((int)lightColor);
        return LightTexture.pack((int)Math.max(this.lightLevel, block), (int)sky);
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double color, double unused, double light) {
            int intColor = (int)color;
            float r = (float)FastColor.ARGB32.red((int)intColor) / 255.0f;
            float g = (float)FastColor.ARGB32.green((int)intColor) / 255.0f;
            float b = (float)FastColor.ARGB32.blue((int)intColor) / 255.0f;
            ColoredSplashParticle p = new ColoredSplashParticle(level, x, y, z, (int)light);
            p.setColor(r, g, b);
            p.pickSprite(this.sprites);
            return p;
        }
    }
}

