/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.level;

import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiDistantGeneratorProgressDisplayLocation;
import com.seibel.distanthorizons.core.api.internal.ClientApi;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.file.fullDatafile.GeneratedFullDataSourceProvider;
import com.seibel.distanthorizons.core.generation.IFullDataSourceRetrievalQueue;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.logging.f3.F3Screen;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos2D;
import com.seibel.distanthorizons.core.util.FormatUtil;
import com.seibel.distanthorizons.core.util.ThreadUtil;
import com.seibel.distanthorizons.core.util.objects.RollingAverage;
import com.seibel.distanthorizons.core.util.threading.PriorityTaskPicker;
import com.seibel.distanthorizons.core.util.threading.ThreadPoolUtil;
import com.seibel.distanthorizons.core.world.DhApiWorldProxy;
import java.io.Closeable;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public class LodRequestModule
implements Closeable {
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    private final GeneratedFullDataSourceProvider.IOnWorldGenCompleteListener onWorldGenCompleteListener;
    private final ThreadPoolExecutor tickerThread;
    private final GeneratedFullDataSourceProvider dataSourceProvider;
    private final Supplier<? extends AbstractLodRequestState> worldGenStateSupplier;
    private final AtomicReference<AbstractLodRequestState> lodRequestStateRef = new AtomicReference();

    public LodRequestModule(IDhLevel level, GeneratedFullDataSourceProvider.IOnWorldGenCompleteListener onWorldGenCompleteListener, GeneratedFullDataSourceProvider dataSourceProvider, Supplier<? extends AbstractLodRequestState> worldGenStateSupplier) {
        this.onWorldGenCompleteListener = onWorldGenCompleteListener;
        this.dataSourceProvider = dataSourceProvider;
        this.worldGenStateSupplier = worldGenStateSupplier;
        String levelId = level.getLevelWrapper().getDhIdentifier();
        this.tickerThread = ThreadUtil.makeSingleDaemonThreadPool("Request Module Ticker [" + levelId + "]");
        this.tickerThread.execute(this::tickLoop);
    }

    private void tickLoop() {
        try {
            while (!Thread.interrupted()) {
                Thread.sleep(20L);
                this.tick();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void tick() {
        DhBlockPos2D targetPosForGeneration;
        AbstractLodRequestState lodRequestState;
        boolean shouldDoWorldGen = this.onWorldGenCompleteListener.shouldDoWorldGen();
        boolean bl = !DhApiWorldProxy.INSTANCE.getReadOnly();
        boolean isWorldGenRunning = this.isWorldGenRunning();
        if ((shouldDoWorldGen &= bl) && !isWorldGenRunning) {
            this.startWorldGen(this.dataSourceProvider, this.worldGenStateSupplier.get());
        } else if (!shouldDoWorldGen && isWorldGenRunning) {
            this.stopWorldGen(this.dataSourceProvider);
        }
        if (this.isWorldGenRunning() && (lodRequestState = this.lodRequestStateRef.get()) != null && (targetPosForGeneration = this.onWorldGenCompleteListener.getTargetPosForGeneration()) != null) {
            lodRequestState.startRequestQueueAndSetTargetPos(targetPosForGeneration);
        }
    }

    public void startWorldGen(GeneratedFullDataSourceProvider dataFileHandler, AbstractLodRequestState newWgs) {
        if (!this.lodRequestStateRef.compareAndSet(null, newWgs)) {
            LOGGER.warn("Failed to start world gen due to concurrency", new Object[0]);
            newWgs.closeAsync(false);
        }
        dataFileHandler.addWorldGenCompleteListener(this.onWorldGenCompleteListener);
        dataFileHandler.setWorldGenerationQueue(newWgs.retrievalQueue);
    }

    public void stopWorldGen(GeneratedFullDataSourceProvider dataFileHandler) {
        AbstractLodRequestState worldGenState = this.lodRequestStateRef.get();
        if (worldGenState == null) {
            LOGGER.warn("Attempted to stop world gen when it was not running", new Object[0]);
            return;
        }
        while (!this.lodRequestStateRef.compareAndSet(worldGenState, null)) {
            worldGenState = this.lodRequestStateRef.get();
            if (worldGenState != null) continue;
            return;
        }
        dataFileHandler.clearRetrievalQueue();
        worldGenState.closeAsync(true).join();
        dataFileHandler.removeWorldGenCompleteListener(this.onWorldGenCompleteListener);
    }

    @Override
    public void close() {
        this.tickerThread.shutdownNow();
        AbstractLodRequestState worldGenState = this.lodRequestStateRef.get();
        if (worldGenState != null) {
            while (!this.lodRequestStateRef.compareAndSet(worldGenState, null) && (worldGenState = this.lodRequestStateRef.get()) != null) {
            }
            if (worldGenState != null) {
                worldGenState.closeAsync(true).join();
            }
        }
    }

    public boolean isWorldGenRunning() {
        return this.lodRequestStateRef.get() != null;
    }

    public void addDebugMenuStringsToList(List<String> messageList) {
        AbstractLodRequestState worldGenState = this.lodRequestStateRef.get();
        if (worldGenState == null) {
            return;
        }
        String waitingCountStr = F3Screen.NUMBER_FORMAT.format(worldGenState.retrievalQueue.getWaitingTaskCount());
        String inProgressCountStr = F3Screen.NUMBER_FORMAT.format(worldGenState.retrievalQueue.getInProgressTaskCount());
        String totalCountEstimateStr = F3Screen.NUMBER_FORMAT.format(worldGenState.retrievalQueue.getRetrievalEstimatedRemainingChunkCount());
        String message = "World Gen/Import Tasks: " + waitingCountStr + "/" + totalCountEstimateStr + " (in progress " + inProgressCountStr + ")";
        double chunksPerSec = worldGenState.getEstimatedChunksPerSecond();
        if (chunksPerSec > -1.0) {
            message = message + ", " + F3Screen.NUMBER_FORMAT.format(chunksPerSec) + " chunks/sec";
        }
        messageList.add(message);
        worldGenState.retrievalQueue.addDebugMenuStringsToList(messageList);
    }

    public static abstract class AbstractLodRequestState {
        private static long firstProgressMessageSentMs = 0L;
        public IFullDataSourceRetrievalQueue retrievalQueue;
        private static final ThreadPoolExecutor PROGRESS_UPDATER_THREAD = ThreadUtil.makeSingleDaemonThreadPool("World Gen Progress Updater");
        private boolean progressUpdateThreadRunning = false;

        public void startRequestQueueAndSetTargetPos(DhBlockPos2D targetPosForRequest) {
            this.retrievalQueue.startAndSetTargetPos(targetPosForRequest);
            this.startProgressUpdateThread();
        }

        private void startProgressUpdateThread() {
            if (!this.progressUpdateThreadRunning) {
                this.progressUpdateThreadRunning = true;
                PROGRESS_UPDATER_THREAD.execute(() -> {
                    while (this.progressUpdateThreadRunning) {
                        try {
                            this.sendRetrievalProgress();
                            int sleepTimeInSec = Config.Common.WorldGenerator.generationProgressDisplayIntervalInSeconds.get();
                            Thread.sleep((long)sleepTimeInSec * 1000L);
                        }
                        catch (Exception e) {
                            LOGGER.error("Unexpected issue displaying chunk retrieval progress [" + e.getMessage() + "].", e);
                        }
                    }
                });
            }
        }

        private void sendRetrievalProgress() {
            double chunksPerSec;
            int remainingChunkCount = this.retrievalQueue.getRetrievalEstimatedRemainingChunkCount();
            String remainingChunkCountStr = F3Screen.NUMBER_FORMAT.format(remainingChunkCount += this.retrievalQueue.getQueuedChunkCount());
            String message = "DH is generating chunks. " + remainingChunkCountStr + " left.";
            int msToShowDisableInstructions = Config.Common.WorldGenerator.generationProgressDisableMessageDisplayTimeInSeconds.get() * 1000;
            if (msToShowDisableInstructions > 0) {
                long timeSinceFirstMessageInMs = System.currentTimeMillis() - firstProgressMessageSentMs;
                if (firstProgressMessageSentMs == 0L || timeSinceFirstMessageInMs < (long)msToShowDisableInstructions) {
                    message = message + " This message can be hidden in the DH config.";
                }
            }
            if ((chunksPerSec = this.getEstimatedChunksPerSecond()) > 0.0) {
                long estimatedRemainingTime = (long)((double)remainingChunkCount / chunksPerSec);
                message = message + " ETA: " + FormatUtil.formatEta(Duration.ofSeconds(estimatedRemainingTime));
                if (Config.Common.WorldGenerator.generationProgressIncludeChunksPerSecond.get().booleanValue()) {
                    message = message + " at " + F3Screen.NUMBER_FORMAT.format(chunksPerSec) + " chunks/sec";
                }
            }
            if (remainingChunkCount != 0) {
                EDhApiDistantGeneratorProgressDisplayLocation displayLocation = Config.Common.WorldGenerator.showGenerationProgress.get();
                if (displayLocation == EDhApiDistantGeneratorProgressDisplayLocation.OVERLAY) {
                    ClientApi.INSTANCE.showOverlayMessageNextFrame(message);
                } else if (displayLocation == EDhApiDistantGeneratorProgressDisplayLocation.CHAT) {
                    ClientApi.INSTANCE.showChatMessageNextFrame(message);
                } else if (displayLocation == EDhApiDistantGeneratorProgressDisplayLocation.LOG) {
                    LOGGER.info(message, new Object[0]);
                }
                if (firstProgressMessageSentMs == 0L) {
                    firstProgressMessageSentMs = System.currentTimeMillis();
                }
            }
        }

        public double getEstimatedChunksPerSecond() {
            RollingAverage avg = this.retrievalQueue.getRollingAverageChunkGenTimeInMs();
            if (avg == null) {
                return -1.0;
            }
            PriorityTaskPicker.Executor executor = ThreadPoolUtil.getWorldGenExecutor();
            int threadCount = 1;
            if (executor != null) {
                threadCount = executor.getPoolSize();
            }
            double chunksPerSecond = 1.0 / avg.getAverage() * 1000.0;
            chunksPerSecond = (double)threadCount * chunksPerSecond;
            return chunksPerSecond;
        }

        CompletableFuture<Void> closeAsync(boolean doInterrupt) {
            this.progressUpdateThreadRunning = false;
            return ((CompletableFuture)((CompletableFuture)this.retrievalQueue.startClosingAsync(true, doInterrupt).exceptionally(e -> {
                LOGGER.error("Error during first stage of generation queue shutdown, Error: [" + e.getMessage() + "].", e);
                return null;
            })).thenRun(this.retrievalQueue::close)).exceptionally(e -> {
                LOGGER.error("Error during second stage of generation queue shutdown, Error: [" + e.getMessage() + "].", e);
                return null;
            });
        }
    }
}

